package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.RecommendUserMapper;
import cn.wisenergy.mapper.UsersMapper;
import cn.wisenergy.model.app.RecommendUser;
import cn.wisenergy.model.app.User;
import cn.wisenergy.model.vo.UserAndRecommendVo;
import cn.wisenergy.service.app.RecommendUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Slf4j
public class RecommendUserServiceImpl implements RecommendUserService {

    @Autowired
    RecommendUserMapper recommendUserMapper;

    @Autowired
    UsersMapper usersMapper;


    /**
     * 获取用户的直推信息表数据
     * @param userId
     * @return
     */
    @Override
    public RecommendUser getMyRecommed(String userId) {
        return recommendUserMapper.getByUserId(userId);
    }

    public List<UserAndRecommendVo> getMyRecommendInfo(String userId, Integer userLevel){

        //当前用户的邀请码
        String userIntiveCode = usersMapper.getByUserId(userId).getInviteCode();
        //通过用户的邀请码获取各个等级的直推用户信息
        List<User> byInviteCode = usersMapper.getByInviteCode(userIntiveCode,userLevel);
        List<UserAndRecommendVo> userAndRecommendVos = new ArrayList<>();
        for (User user : byInviteCode) {
            UserAndRecommendVo userAndRecommendVo = new UserAndRecommendVo();
            userAndRecommendVo.setUserId(user.getUserId());
            userAndRecommendVo.setMonthyCount(recommendUserMapper.getByUserId(userId).getMonthyCount());
            userAndRecommendVo.setHistoryCount(recommendUserMapper.getByUserId(userId).getHistoryCount());
            userAndRecommendVos.add(userAndRecommendVo);
        }

        return userAndRecommendVos;
    }
}
