package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.DateUtil;
import cn.wisenergy.mapper.*;
import cn.wisenergy.model.app.RecommendUser;
import cn.wisenergy.model.app.TeamPerformance;
import cn.wisenergy.model.app.TeamUserInfo;
import cn.wisenergy.service.app.UserForestStatusService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.xml.ws.soap.Addressing;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 用户森林状态
 * @author 86187
 */
@Service
@Slf4j
public class UserForestStatusServiceImpl implements UserForestStatusService {

    @Autowired
    UsersMapper usersMapper;

    @Autowired
    RecommendUserMapper recommendUserMapper;

    @Autowired
    TeamUserInfoMapper teamUserInfoMapper;

    @Autowired
    TeamPerformanceMapper teamPerformanceMapper;

    @Autowired
    OrderMapper orderMapper;
    /**
     * 根据用户id获取用户森林状态
     * @param userId
     * @return
     */

    //todo：团队当月新增业绩
    @Override
    public Map getUserForestStatus(String userId) {

        //用户升级条件
        BigDecimal levelTerm = new BigDecimal(3980);

        HashMap<Object, Object> userForestStatusMap = new HashMap<>();

        String date = DateUtil.convertDateToStr(new Date(), "yyyy-MM");
        //1.获取当前用户的等级
        Integer userLevel = usersMapper.getByUserId(userId).getUserLevel();
        //2.获取当前用户的直推总人数
        Integer recommendUserCountByUserId = recommendUserMapper.getRecommendUserCountByUserId(userId);
        //3.获取当前用户的团队总人数
        Integer teamUserCount = teamUserInfoMapper.getTeamUserCount(userId);
        //4.团队累计总业绩
        Double teamCountDouble = teamPerformanceMapper.countUserTeamByUserId(userId);
        //5.团队当月新增业绩
        Double teamNowCount = teamPerformanceMapper.monthUserTeamByuserId(userId,date);
        //用户直推表信息
        RecommendUser recommendUserMapperByUserId = recommendUserMapper.getByUserId(userId);
        //用户团队表信息
        TeamUserInfo teamUserInfobyUserId = teamUserInfoMapper.getByUserId(userId);
        //距离下级直推用户还需增加的数量
        int recommend =0;
        //距离下级团队用户还需增加的数量
        int team =0;
        //6.距离下级升级条件
        if(userLevel < 2){
            //用户等级 < 幼苗 显示业绩缺少额度
            //获取当前用户的业绩
            BigDecimal performanceByUserid = orderMapper.getPerformanceByUserid(userId);
            //距离升级还差多少额度
            BigDecimal difference = levelTerm.subtract(performanceByUserid);
            userForestStatusMap.put("difference",difference);
        }else if (userLevel == 2){
            //用户等级为青铜树
            int levelTerm1 = 20;
            Integer seedlingNum = recommendUserMapperByUserId.getSeedlingNum();
            recommend =  levelTerm1 - seedlingNum;
            userForestStatusMap.put("recommend",recommend);
        }else if (userLevel == 3){
            //用户等级为白银树
            int goldLevelRecommend = 54;
            int goldLevelteam = 20;
            //直推用户之和
            Integer countRecommend = recommendUserMapperByUserId.getSeedlingNum()+recommendUserMapperByUserId.getSilverTreeNum();
            //所差直推用户的数量
            recommend = goldLevelRecommend - countRecommend;
            //所差团队用户的数量
            team = goldLevelteam - teamUserInfobyUserId.getBronzeTreeNum();
            userForestStatusMap.put("recommend",recommend);
            userForestStatusMap.put("team",team);

        }else if (userLevel == 4){
            //用户等级为黄金树
            int farmerLevelRecommend = 73;
            int fammerLevelTeam = 40;
            //用户直推之和
            Integer countRecommend = recommendUserMapperByUserId.getSeedlingNum()+recommendUserMapperByUserId.getGoldTreeNum();
            //用户团队之和
            Integer countTeam = teamUserInfobyUserId.getSilverTreeNum();
            //所差直推用户的数量
            recommend = farmerLevelRecommend - countRecommend;
            //所差团队用户的数量
            team = fammerLevelTeam - teamUserInfobyUserId.getBronzeTreeNum();
            userForestStatusMap.put("recommend",recommend);
            userForestStatusMap.put("team",team);

        }else if (userLevel == 5){
            //用户等级为农场主
            int farmerLevelRecommend = 73;
            int fammerLevelTeam = 40;
            //用户直推之和
            Integer countRecommend = recommendUserMapperByUserId.getSeedlingNum()+recommendUserMapperByUserId.getGoldTreeNum();
            //用户团队之和
            Integer countTeam = teamUserInfobyUserId.getSilverTreeNum();
            //所差直推用户的数量
            recommend = farmerLevelRecommend - countRecommend;
            //所差团队用户的数量
            team = fammerLevelTeam - teamUserInfobyUserId.getBronzeTreeNum();
            userForestStatusMap.put("recommend",recommend);
            userForestStatusMap.put("team",team);
        }else if (userLevel == 6){
            //用户等级为森林之星
            int forestStartNumLevelRecommend = 101;
            int forestStartNumLevelTeam = 170;
            //用户直推之和
            Integer countRecommend = recommendUserMapperByUserId.getSeedlingNum()+recommendUserMapperByUserId.getForestStartNum();
            //用户团队之和
            Integer countTeam = teamUserInfobyUserId.getSilverTreeNum()+teamUserInfobyUserId.getGoldTreeNum()+teamUserInfobyUserId.getFarmerNum();
            //所差直推用户的数量
            recommend = forestStartNumLevelRecommend - countRecommend;
            //所差团队用户的数量
            team = forestStartNumLevelTeam - countTeam;
            userForestStatusMap.put("recommend",recommend);
            userForestStatusMap.put("team",team);
        }

        userForestStatusMap.put("userLevel",userLevel);
        userForestStatusMap.put("recommendUserCount",recommendUserCountByUserId);
        userForestStatusMap.put("teamUserCount",teamUserCount);
        if (teamCountDouble == null ){
            userForestStatusMap.put("teamCountDouble",0);
        }else {
            userForestStatusMap.put("teamCountDouble",teamCountDouble);
        }

        if (teamNowCount == null){
            userForestStatusMap.put("teamNowCount",0);
        }else {
            userForestStatusMap.put("teamNowCount",teamNowCount);
        }
        return userForestStatusMap;
    }



//    public
}
