package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.AccountInfo;
import cn.wisenergy.model.app.User;
import cn.wisenergy.service.app.AccountService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author 86187
 */
@Api(tags = "账户管路")
@RestController
@RequestMapping("/account")
@Slf4j
public class AccountController {
    @Autowired
    private AccountService accountService;

    @ApiOperation(value = "获取账户信息", notes = "获取账户信息", httpMethod = "GET")
    @ApiImplicitParam(name = "userId", value = "用户id", dataType = "String")
    @GetMapping("/getByUserId")
    public R<AccountInfo> getByUserId(String userId){
        return accountService.getByUserId(userId);
    }

    @ApiOperation(value = "获取账户列表信息", notes = "获取账户列表信息", httpMethod = "GET")
    @ApiImplicitParam(name = "userId", value = "用户id", dataType = "String")
    @GetMapping("/getByList")
    public List<User> getByList(String userId){
        return accountService.getByList(userId);
    }

    @ApiOperation(value = "订单佣金", notes = "订单佣金", httpMethod = "GET")
    @GetMapping("/orderRebate")
    public R<Boolean> orderRebate(){
        return accountService.orderRebate();
    }
}
