package cn.wisenergy.common.utils;


import cn.wisenergy.common.enums.ResultEnum;
import org.springframework.stereotype.Component;

import java.io.Serializable;
import java.util.Map;

/**
 * 返回信息包装类
 * Created by m1991 on 2021/2/28 23:08
 */
@Component
public class Result<T> implements Serializable {
    public String code;

    public String msg;

    private T data;

    private T wyz;

    /**
     * 无参构造
     */
    public Result() {}
    /**
     * 无参构造
     * @param i
     * @param success
     * @param shopZxPage
     */
    public Result(int i, String success, Page shopZxPage) {}

    /**
     * 根据code，msg创建一个Resutl
     * @param code
     * @param msg
     */
    public Result(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * 根据code，msg，data创建一个Resutl
     * @param code
     * @param msg
     * @param data
     */
    public Result(String code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public T getWyz() {
        return wyz;
    }

    public void setWyz(T wyz) {
        this.wyz = wyz;
    }

    public Result(String code, String msg, T data, T wyz) {
        this.code = code;
        this.msg = msg;
        this.data = data;
        this.wyz = wyz;
    }

    /**
     * 根据枚举创建一个Result
     * @param resultEnum
     */
    public Result(ResultEnum resultEnum) {
        this.code = resultEnum.getCode();
        this.msg = resultEnum.getMsg();
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }


}
