package cn.wisenergy.mapper;

import cn.wisenergy.model.app.MonthAward;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;

/**
 * @author 86187
 */
public interface MonthAwardMapper extends BaseMapper<MonthAward> {

    /**
     * 添加
     *
     * @param monthAward 奖励信息
     * @return 1
     */
    int add(MonthAward monthAward);

    /**
     * 编辑
     *
     * @param monthAward 奖励信息
     * @return 1
     */
    int edit(MonthAward monthAward);

    /**
     * 删除
     *
     * @param id 主键id
     * @return 1
     */
    int delById(Integer id);

    /**
     * 获取本月 月度奖金
     * @param yearMonth 年月
     * @return 月度奖金
     */
    MonthAward getByTime(@Param("yearMonth") String yearMonth);
}
