package cn.wisenergy.mapper;

import cn.wisenergy.model.app.RecommendUser;
import cn.wisenergy.model.app.TeamUserInfo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;

/**
 * 团队Mapper
 * @author zw
 */
public interface TeamUserInfoMapper extends BaseMapper<TeamUserInfo> {

//    TeamUserInfo getByUserId(String userid);
    //根据userId查询用户是否存在
    Integer czByUserId(String userId);
    /**
     * 获取用户的团队信息
     * @param userId 用户Id
     * @return 用户的团队信息
     */
    TeamUserInfo getByUserId(String userId);

    /**
     * 获取用户的团队总人数
     * @param userId 用户Id
     * @return 团队总人数
     */
    Integer getTeamUserCount(String userId);

    int add(TeamUserInfo teamUserInfo);

    int edit(TeamUserInfo teamUserInfo);
}
