package cn.wisenergy.mapper;

import cn.wisenergy.model.app.TradeRecord;
import cn.wisenergy.model.vo.AccumulatedIncomeVo;
import cn.wisenergy.model.vo.WithdrawalRecordVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author 86187
 */
public interface TradeRecordMapper extends BaseMapper<TradeRecord> {

    /**
     * 添加交易记录
     *
     * @param tradeRecord 记录信息
     * @return 1
     */
    int add(TradeRecord tradeRecord);

    /**
     * 编辑交易记录
     *
     * @param tradeRecord 记录信息
     * @return 1
     */
    int edit(TradeRecord tradeRecord);

    /**
     * 删除
     *
     * @param id 主键
     * @return 1
     */
    int delById(@Param("id") Integer id);

    /**
     * 根据用户id,获取用户交易列表
     *
     * @param userId 用户id
     * @return 用户交易列表
     */
    List<TradeRecord> getByUserId(@Param("userId") String userId);

    /**
     * 根据用户id、年月 ,获取用户本月交易列表
     *
     * @param userId 用户id
     * @return 用户交易列表
     */
    List<TradeRecord> getByUserIdAndTime(@Param("userId") String userId, @Param("yearMonth") Date yearMonth);

    /**
     * 获取不包括本月的六个月的累计收益
     *
     * @param userId 用户id
     * @return 累计收益
     */
    List<AccumulatedIncomeVo> getSixMonthIncome(@Param("userId") String userId);

    /**
     * 根据用户id 或 年月 ,获取用户本月交易提现列表
     *
     * @param userId    用户id
     * @param yearMonth 年月
     * @return 交易列表
     */
    List<WithdrawalRecordVo> getWithdrawalRecord(@Param("userId") String userId, @Param("yearMonth") Date yearMonth);


    /**
     * 获取用户本月累计奖金
     *
     * @param userId    用户id
     * @param yearMonth 年月
     * @return
     */
    Double queryMonthAward(@Param("userId") String userId, @Param("yearMonth") Date yearMonth);

    /**
     * 获取本月新增奖金（月度肥料）
     *
     * @param yearMonth 时间
     * @return 本月新增奖金
     */
    Double queryMonthGrow(@Param("yearMonth") Date yearMonth);

    /**
     * 获取历史累计奖金 -时间小于yearMonth （月度肥料）
     *
     * @param yearMonth 时间
     * @return 本月新增奖金
     */
    Double queryAllAward(@Param("yearMonth") Date yearMonth);

    /**
     * 获取用户等级 月奖金---时间小于yearMonth （月度肥料）
     *
     * @param userLevel 用户等级
     * @param yearMonth 时间
     * @return 用户等级 月奖金
     */
    Double queryByUserLevel(@Param("userLevel") Integer userLevel, @Param("yearMonth") Date yearMonth);

    /**
     * 统计交易流水总记录数
     *
     * @param map 入参
     * @return 结果
     */
    int count( Map<String, Object> map);

    /**
     * 获取交易流水列表
     * @param map 入参
     * @return 结果集
     */
    List<TradeRecord> getList(Map<String, Object> map);

}
