package cn.wisenergy.mapper;

import cn.wisenergy.model.app.Variable;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

/**
 * @author 86187
 * @ Description:  变量表mapper
 * @ Author     : 86187
 * @ Date       : 2021/3/15 15:09
 */
public interface VariableMapper extends BaseMapper<Variable> {
    /**
     * 新增
     *
     * @param variable 变量信息
     * @return 1
     */
    int add(Variable variable);

    /**
     * 编辑
     *
     * @param variable 变量信息
     * @return 1
     */
    int edit(Variable variable);

    /**
     * 删除
     *
     * @param id 主键id
     * @return 1
     */
    int delById(@Param("id") Integer id);

    /**
     * 根据key,获取变量信息
     * @param variableKey 变量唯一标识
     * @return 变量信息
     */
    Variable getByKey(@Param("variableKey") String variableKey);
}
