package cn.wisenergy.model.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 账户实体类
 *
 * @author 86187
 */
@Data
@ApiModel(value = "AccountInfo")
public class AccountInfo implements Serializable {

    private static final long serialVersionUID = 3050641578536493424L;
    /**
     * 账户主键id
     */
    @ApiModelProperty(name = "id", value = "管理员主键id")
    private Integer id;

    /**
     * 用户id
     */
    @ApiModelProperty(name = "userId", value = "用户id")
    private String userId;

    /**
     * 用户等级
     */
    @ApiModelProperty(name = "userLevel", value = "用户等级")
    private Integer userLevel;

    /**
     * 年月
     */
    @ApiModelProperty(name = "yearMonth", value = "年月")
    private String yearMonth;


    /**
     * 可提现金额
     */
    @ApiModelProperty(name = "extractMoney", value = "可提现金额")
    private BigDecimal extractMoney;

    /**
     * 本月收益
     */
    @ApiModelProperty(name = "earningsMonth", value = "本月收益")
    private BigDecimal earningsMonth;


    /**
     * 冻结金额
     */
    @ApiModelProperty(name = "frozenMoney", value = "冻结金额")
    private BigDecimal frozenMoney;

    /**
     * 累计收益
     */
    @ApiModelProperty(name = "earningsTotal", value = "累计收益")
    private BigDecimal earningsTotal;

    /**
     * 冻结状态 0：未冻结 1：冻结
     */
    @ApiModelProperty(name = "frozenStatus", value = "冻结状态 0：未冻结 1：冻结")
    private Integer frozenStatus;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;
    /**
     * 修改时间
     */
    @ApiModelProperty(name = "updateTime", value = "修改时间")
    private Date updateTime;
}
