package cn.wisenergy.model.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
*@ Description: 月度奖励实体类
*@ Author     : 86187
*@ Date       : 2021/2/24 16:16
 * @author 86187
 */
@Data
@ApiModel("MonthAward")
public class MonthAward implements Serializable {
    private static final long serialVersionUID = 5823242406761516398L;

    /**
     * 主键id
     */
    @ApiModelProperty(value = "主键id",name="id")
    private Integer id;

    /**
     * 与上一次比较的增长奖金
     */
    @ApiModelProperty(name = "growthAward", value = "与上一次比较的增长额度")
    private Double growthAward;

    /**
     * 历史奖金总额
     */
    @ApiModelProperty(value = "历史奖金总额",name="awardTotal")
    private Double awardTotal;

    /**
     * 本月累计奖金总额（本月新增+上月没有分出去的月度肥料奖金）
     */
    @ApiModelProperty(value = "本月累计奖金总额",name="monthAwardTotal")
    private Double monthAwardTotal;

    /**
     * 本月新增
     */
    @ApiModelProperty(value = "本月新增",name="monthIncreased")
    private Double monthIncreased;

    /**
     * 黄金树月奖励总额
     */
    @ApiModelProperty(value = "黄金树月奖励总额",name="goldAward")
    private Double goldAward;


    /**
     * 农场主月奖励总额
     */
    @ApiModelProperty(value = "农场主月奖励总额",name="farmerAward")
    private Double farmerAward;

    /**
     * 森林之星月奖励总额
     */
    @ApiModelProperty(value = "森林之星月奖励总额",name="forestStartAward")
    private Double forestStartAward;

    /**
     * 森田合伙人月奖励总额
     */
    @ApiModelProperty(value = "森田合伙人月奖励总额",name="partnerAward")
    private Double partnerAward;

    /**
     * 时间 ：yyyy-MM
     */
    @ApiModelProperty(value = "时间 ：yyyy-MM",name="yearMonth")
    private String yearMonth;

    private Date createTime;

    private Date updateTime;


}
