package cn.wisenergy.model.app;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author 86187
 * @ Description   :  用户实体类
 * @ Author        :  lcc
 * @ CreateDate    :  2020/11/8 19:59
 */
@Data
@ApiModel(value = "User")
@TableName("user_info")
public class User  implements Serializable{
    private static final long serialVersionUID = 2525339404301884673L;

    /**
     * 主键id
     */
    @ApiModelProperty(name = "id", value = "用户主键id")
    private Integer id;


    /**
     * 手机号作为用户账号
     */
    @ApiModelProperty(name = "user_id", value = "用户id")
    private String userId;

    /**
     * 密码
     */
    @ApiModelProperty(name = "password", value = "用户密码")
    private String password;

    /**
     * 用户头像
     */
    @ApiModelProperty(name = "用户头像", value = "headImage")
    private String headImage;


    /**
     * 用户会员等级
     */
    @ApiModelProperty(name = "user_level", value = "用户会员等级")
    private int userLevel;

    /**
     * 跨境额度
     */
    @ApiModelProperty(name = "cross_border_line", value = "跨境额度")
    private BigDecimal crossBorderLine;

    /**
     * 身份证号码
     */
    @ApiModelProperty(name = "id_card_number", value = "身份证号码")
    private String idCardNumber;

    /**
     * 粉丝昵称
     */
    @ApiModelProperty(name = "fans_nickname", value = "粉丝昵称")
    private String fansNickname;

    /**
     * 有赞粉丝id，有赞自动生成
     */
    @ApiModelProperty(name = "fans_id", value = "有赞粉丝id，有赞自动生成")
    private String fansId;

    /**
     * 用户本人邀请码
     */
    @ApiModelProperty(name = "invite_code", value = "用户本人邀请码")
    private String inviteCode;

    /**
     * 推荐人邀请码
     */
    @ApiModelProperty(name = "be_invited_code", value = "推荐人邀请码")
    private String beInvitedCode;

    /**
     * 专属客服id
     */
    @ApiModelProperty(name = "customerServiceId", value ="专属客服id" )
    private String customerServiceId;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;
    /**
     * 修改时间
     */
    @ApiModelProperty(name = "updateTime", value = "修改时间")
    private Date updateTime;

    /**
     * 账户冻结字段 0正常  1冻结
     */
    @ApiModelProperty(name = "frozen", value = "账户冻结字段")
    private Integer frozen;

    public Integer getFrozen() {
        return frozen;
    }

    public void setFrozen(Integer frozen) {
        this.frozen = frozen;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHeadImage() {
        return headImage;
    }

    public void setHeadImage(String headImage) {
        this.headImage = headImage;
    }

    public int getUserLevel() {
        return userLevel;
    }

    public void setUserLevel(int userLevel) {
        this.userLevel = userLevel;
    }

    public BigDecimal getCrossBorderLine() {
        return crossBorderLine;
    }

    public void setCrossBorderLine(BigDecimal crossBorderLine) {
        this.crossBorderLine = crossBorderLine;
    }

    public String getIdCardNumber() {
        return idCardNumber;
    }

    public void setIdCardNumber(String idCardNumber) {
        this.idCardNumber = idCardNumber;
    }

    public String getFansNickname() {
        return fansNickname;
    }

    public void setFansNickname(String fansNickname) {
        this.fansNickname = fansNickname;
    }

    public String getFansId() {
        return fansId;
    }

    public void setFansId(String fansId) {
        this.fansId = fansId;
    }

    public String getInviteCode() {
        return inviteCode;
    }

    public void setInviteCode(String inviteCode) {
        this.inviteCode = inviteCode;
    }

    public String getBeInvitedCode() {
        return beInvitedCode;
    }

    public void setBeInvitedCode(String beInvitedCode) {
        this.beInvitedCode = beInvitedCode;
    }

    public String getCustomerServiceId() {
        return customerServiceId;
    }

    public void setCustomerServiceId(String customerServiceId) {
        this.customerServiceId = customerServiceId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}
