package cn.wisenergy.service.Manager;

import cn.wisenergy.common.utils.DateUtil;
import cn.wisenergy.mapper.*;
import cn.wisenergy.model.app.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author 86187
 * @ Description:  用户登录注册事务管理
 * @ Author     : 86187
 * @ Date       : 2021/3/17 11:32
 */
@Component
@Slf4j
public class LoginManager {

    @Autowired
    private RecommendUserMapper recommendUserMapper;

    @Autowired
    private TeamUserInfoMapper teamUserInfoMapper;

    @Autowired
    private CultivatingPrizeInfoMapper cultivatingPrizeInfoMapper;

    @Autowired
    private AccountMapper accountMapper;

    @Autowired
    private TeamPerformanceMapper teamPerformanceMapper;

    @Autowired
    private UsersMapper usersMapper;

    /**
     * 用户注册初始化信息
     *
     * @param user 用户信息
     * @return true or false
     */
    @Transactional(rollbackFor = Exception.class)
    public boolean initUserInfo(User user, List<TeamUserInfo> list) {
        String userId = user.getUserId();
        String yearMonth = DateUtil.convertDateToStr(new Date(), "yyyy-MM");

        //保存用户信息
        int userCount = usersMapper.add(user);
        if (userCount == 0) {
            return false;
        }

        //直推用户表维护
        boolean bool = initRecommendUser(userId);
        if (!bool) {
            return false;
        }

        //团队用户表数据维护
        boolean teamBool = initTeamUserInfo(userId);
        if (!teamBool) {
            return false;
        }

        //培育奖记录数据维护
        boolean prizeBool = initCultivatingPrizeInfo(userId);
        if (!prizeBool) {
            return false;
        }

        //账户表记录数据维护
        boolean accountBool = initAccountInfo(userId, yearMonth);
        if (!accountBool) {
            return false;
        }

        //团队业绩表数据维护
        boolean perforBool = initTeamPerformance(userId, yearMonth);
        if (!perforBool) {
            return false;
        }

        //更新用户上级直推用户
        if (!CollectionUtils.isEmpty(list)) {
            for (TeamUserInfo teamUser : list) {
                teamUser.setNormalUserNum(teamUser.getNormalUserNum() + 1);
                int number = teamUserInfoMapper.edit(teamUser);
                if (number == 0) {
                    return false;
                }
            }
        }

        return true;
    }


    private boolean initRecommendUser(String userId) {
        RecommendUser recommendUser = new RecommendUser();
        recommendUser.setUserId(userId);
        recommendUser.setNormalUserNum(0);
        recommendUser.setSeedlingNum(0);
        recommendUser.setBronzeTreeNum(0);
        recommendUser.setSilverTreeNum(0);
        recommendUser.setGoldTreeNum(0);
        recommendUser.setFarmerNum(0);
        recommendUser.setForestStartNum(0);
        recommendUser.setPartnerNum(0);
        recommendUser.setMonthyCount(new BigDecimal(0));
        recommendUser.setHistoryCount(new BigDecimal(0));
        int count = recommendUserMapper.add(recommendUser);
        return count != 0;
    }

    private boolean initTeamUserInfo(String userId) {
        TeamUserInfo teamUserInfo = new TeamUserInfo();
        teamUserInfo.setUserId(userId);
        teamUserInfo.setNormalUserNum(0);
        teamUserInfo.setSeedlingNum(0);
        teamUserInfo.setBronzeTreeNum(0);
        teamUserInfo.setSilverTreeNum(0);
        teamUserInfo.setGoldTreeNum(0);
        teamUserInfo.setFarmerNum(0);
        teamUserInfo.setForestStartNum(0);
        teamUserInfo.setPartnerNum(0);
        int teamAdd = teamUserInfoMapper.add(teamUserInfo);
        return teamAdd != 0;
    }

    private boolean initCultivatingPrizeInfo(String userId) {
        CultivatingPrizeInfo cultivatingPrizeInfo = new CultivatingPrizeInfo();
        cultivatingPrizeInfo.setUserId(userId);
        cultivatingPrizeInfo.setSeedling(0);
        cultivatingPrizeInfo.setBronzeTree(0);
        cultivatingPrizeInfo.setSilverTree(0);
        cultivatingPrizeInfo.setGoldTree(0);
        cultivatingPrizeInfo.setFarmer(0);
        cultivatingPrizeInfo.setForestStart(0);
        cultivatingPrizeInfo.setPartner(0);
        int prize = cultivatingPrizeInfoMapper.add(cultivatingPrizeInfo);
        return prize != 0;
    }

    private boolean initAccountInfo(String userId, String yearMonth) {
        AccountInfo accountInfo = new AccountInfo();
        accountInfo.setUserId(userId);
        accountInfo.setUserLevel(0);
        accountInfo.setYearMonth(yearMonth);
        accountInfo.setExtractMoney(new BigDecimal(0));
        accountInfo.setEarningsMonth(new BigDecimal(0));
        accountInfo.setFrozenMoney(new BigDecimal(0));
        accountInfo.setEarningsTotal(new BigDecimal(0));
        accountInfo.setFrozenStatus(0);
        int sum = accountMapper.add(accountInfo);
        return sum != 0;
    }

    private boolean initTeamPerformance(String userId, String yearMonth) {
        TeamPerformance teamPerformance = new TeamPerformance();
        teamPerformance.setUserId(userId);
        teamPerformance.setUserLevel(0);
        teamPerformance.setYearMonth(yearMonth);
        teamPerformance.setMonthTeamPerformance(new BigDecimal(0));
        int teamCount = teamPerformanceMapper.add(teamPerformance);
        return teamCount != 0;
    }
}
