package cn.wisenergy.service.Manager;

import cn.wisenergy.mapper.*;
import cn.wisenergy.model.app.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

@Component
@Slf4j
public class RegistUserMoudleInitManager {

    @Autowired
    private RecommendUserMapper recommendUserMapper;

    @Autowired
    private TeamUserInfoMapper teamUserInfoMapper;

    @Autowired
    private CultivatingPrizeInfoMapper cultivatingPrizeInfoMapper;

    @Autowired
    private AccountMapper accountMapper;

    @Autowired
    TeamPerformanceMapper teamPerformanceMapper;


    /**
     * 注册时用户初始化
     *
     * @param userId
     * @return
     */
    @Transactional
    public Boolean registUserMoudleInit(String userId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        String data = sdf.format(new Date());

        try {
            //直推用户表维护
            RecommendUser recommendUser = new RecommendUser();
            recommendUser.setUserId(userId);
            recommendUser.setNormalUserNum(0);
            recommendUser.setSeedlingNum(0);
            recommendUser.setBronzeTreeNum(0);
            recommendUser.setSilverTreeNum(0);
            recommendUser.setGoldTreeNum(0);
            recommendUser.setFarmerNum(0);
            recommendUser.setForestStartNum(0);
            recommendUser.setPartnerNum(0);
            recommendUser.setMonthyCount(new BigDecimal(0));
            recommendUser.setHistoryCount(new BigDecimal(0));
            recommendUserMapper.add(recommendUser);

            //团队用户表数据维护
            TeamUserInfo teamUserInfo = new TeamUserInfo();
            teamUserInfo.setUserId(userId);
            teamUserInfo.setNormalUserNum(0);
            teamUserInfo.setSeedlingNum(0);
            teamUserInfo.setBronzeTreeNum(0);
            teamUserInfo.setSilverTreeNum(0);
            teamUserInfo.setGoldTreeNum(0);
            teamUserInfo.setFarmerNum(0);
            teamUserInfo.setForestStartNum(0);
            teamUserInfo.setPartnerNum(0);
            teamUserInfoMapper.add(teamUserInfo);

            //培育奖记录数据维护
            CultivatingPrizeInfo cultivatingPrizeInfo = new CultivatingPrizeInfo();
            cultivatingPrizeInfo.setUserId(userId);
            cultivatingPrizeInfo.setSeedling(0);
            cultivatingPrizeInfo.setBronzeTree(0);
            cultivatingPrizeInfo.setSilverTree(0);
            cultivatingPrizeInfo.setGoldTree(0);
            cultivatingPrizeInfo.setFarmer(0);
            cultivatingPrizeInfo.setForestStart(0);
            cultivatingPrizeInfo.setPartner(0);
            cultivatingPrizeInfoMapper.add(cultivatingPrizeInfo);

            //账户表记录数据维护
            AccountInfo accountInfo = new AccountInfo();
            accountInfo.setUserId(userId);
            accountInfo.setUserLevel(0);
            accountInfo.setYearMonth(data);
            accountInfo.setExtractMoney(new BigDecimal(0));
            accountInfo.setEarningsMonth(new BigDecimal(0));
            accountInfo.setFrozenMoney(new BigDecimal(0));
            accountInfo.setEarningsTotal(new BigDecimal(0));
            accountInfo.setFrozenStatus(0);
            accountMapper.add(accountInfo);

            //团队业绩表数据维护
            TeamPerformance teamPerformance = new TeamPerformance();
            teamPerformance.setUserId(userId);
            teamPerformance.setUserLevel(0);
            teamPerformance.setYearMonth(data);
            teamPerformance.setMonthTeamPerformance(new BigDecimal(0));
            teamPerformanceMapper.add(teamPerformance);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

}
