package cn.wisenergy.service.app;


import cn.wisenergy.model.app.User;

import java.util.Map;

/**
 * @author 86187
 */
public interface AerialDeliveryUserService {
    /**
     * 空投池用户随机分配推荐人邀请码
     */
    void aerialDeliveryUserRand();

    /**
     * 设置邀请码接口 维护直推和团队数据
     * @param userId  当前用户id
     * @param userInvitedId  推荐人用户id
     */
    void userSetBeinviteCode(String userId, String userInvitedId);

    /**
     * 团队整体数据的计算
     * @param beInvitedUserId  推荐人的用户id
     * @param userId 当前用户的id
     * @return  map  团队中各等级的用户数量
     */
    Map teamUserInfoByAerialDelivery(String beInvitedUserId, String userId);


    /**
     * 整体团队数据维护
     * @param teamDataMap teamUserInfoByAerialDelivery 返回的map
     * @param userId  当前用户的userid
     */
    void teamData(Map<String, Integer> teamDataMap, String userId);

    /**
     * 查询当前用户所在团队的最上级用户
     * @param userId  当前用户的userID
     * @return  user  当前用户所在的最上级用户
     */
    User highUser(String userId);


    /**
     * 团队数据维护  只维护团队数据 不包含直推数据的维护
     * @param userId  当期用户的userId
     * @param userInvitedId  推荐人的userId
     */
    void teamDataNotRecommend(String userId, String userInvitedId);
}
