package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.User;
import cn.wisenergy.model.app.UsersDto;
import cn.wisenergy.model.vo.AerialDeliveryVo;
import cn.wisenergy.model.vo.UserRegisterVo;

import java.util.Map;

/**
 * @author 86187
 * @author 86187
 * @ Description: 用户接口
 * @ Author     : 86187
 * @ Date       : 2021/1/6 16:08
 */
public interface UserService {


    /**
     * 获取用户信息
     *
     * @param userId 用户id
     * @return 用户信息
     */
    User getById(String userId);

    /**
     * 获取登录用户
     *
     * @param token
     * @return
     */
    UsersDto getLoginUser(String token);

    R<Integer> getById1(String userId);

    User getUserById(Long id);

    /**
     * 获取用户信息
     *
     * @param userId 用户id
     * @return 用户信息
     */
    User getByUserId(String userId);

    /**
     * 根据手机号查询用户
     */
    User queryUsersByPhone(String userId);

    /**
     * 根据OpenId查询用户
     */
    User queryUsersByOpenId(String openId);

    /**
     * 用户注册
     */
    Map userByZx(String userId, String beInvitedCode);

    /**
     * 用户登出
     *
     * @param token
     * @return
     */
    int logout(String token);

    Integer getUserIdById(String userId);

    /**
     * 空投池
     *
     * @return 用户列表信息
     */
    R<AerialDeliveryVo> queryAerialDelivery();

    /**
     * 设置用户头像
     *
     * @param userId    用户id
     * @param headImage 头像图片地址
     * @return true or false
     */
    R<Boolean> setHeadImage(String userId, String headImage);

    /**
     * 设置页面 -邀请码填写
     *
     * @param userId     用户id
     * @param inviteCode 邀请人邀请码
     * @return true or false
     */
    R<Boolean> fillInInviteCode(String userId, String inviteCode);

}
