package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.constant.CommonAttributes;
import cn.wisenergy.common.utils.DateUtil;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.TeamPerformanceMapper;
import cn.wisenergy.model.app.TeamPerformance;
import cn.wisenergy.model.dto.TeamQueryDto;
import cn.wisenergy.service.app.TeamPerformanceService;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author 86187
 */
@Slf4j
@Service
public class TeamPerformanceServiceImpl implements TeamPerformanceService {
    @Autowired
    private TeamPerformanceMapper teamPerformanceMapper;

    @Override
    public R<PageInfo<TeamPerformance>> getList(TeamQueryDto query) {
        log.info("shop-mall[]TeamPerformanceServiceImpl[]getList[]input.param.query:" + query);
        if (null == query) {
            return R.error("入参不能为空!");
        }

        pageHandle(query);

        Map<String, Object> map = new HashMap<>(8);
        map.put("userId", query.getUserId());
        if (!StringUtils.isBlank(query.getQueryTime())) {
            Date date = DateUtil.convertStrToDate(query.getQueryTime(), "yyyy-MM-dd");
            map.put("queryTime", date);
        }
        int total = teamPerformanceMapper.count(map);

        map.put("startNum", query.getStartNum());
        map.put("endNum", query.getEndNum());
        List<TeamPerformance> list = teamPerformanceMapper.getList(map);
        PageInfo<TeamPerformance> info = new PageInfo<>();
        info.setPageSize(query.getPageSize());
        info.setPageNum(query.getPageNo());
        info.setTotal(total);
        info.setList(list);

        return R.ok(info);
    }

    /**
     * 分页处理方法
     *
     * @param schemeVo 参数
     */
    private void pageHandle(TeamQueryDto schemeVo) {
        Integer pageNum = schemeVo.getPageNo();
        Integer pageSize = schemeVo.getPageSize();
        if (null == pageSize || pageSize == 0) {
            pageSize = 10;
        }
        if (null == pageNum || pageNum == 0) {
            pageNum = 1;
        }
        Integer endNum = pageSize;
        Integer startNum = (pageNum - CommonAttributes.NUM_ONE) * pageSize;
        schemeVo.setEndNum(endNum);
        schemeVo.setStartNum(startNum);
        schemeVo.setPageNo(pageNum);
        schemeVo.setPageSize(pageSize);
    }
}
