package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.constant.CommonAttributes;
import cn.wisenergy.common.utils.DateUtil;
import cn.wisenergy.common.utils.R;
import cn.wisenergy.mapper.MonthAwardMapper;
import cn.wisenergy.mapper.MonthManureMapper;
import cn.wisenergy.mapper.TradeRecordMapper;
import cn.wisenergy.model.app.MonthAward;
import cn.wisenergy.model.app.MonthManure;
import cn.wisenergy.model.app.TradeRecord;
import cn.wisenergy.model.dto.TradeRecordQuery;
import cn.wisenergy.model.enums.UserLevelEnum;
import cn.wisenergy.service.app.TradeRecordService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author 86187
 */
@Service
@Slf4j
public class TradeRecordServiceImpl extends ServiceImpl<TradeRecordMapper, TradeRecord> implements TradeRecordService {
    @Autowired
    private MonthManureMapper monthManureMapper;

    @Autowired
    private MonthAwardMapper monthAwardMapper;

    @Autowired
    private TradeRecordMapper tradeRecordMapper;

    @Override
    public R<Boolean> monthAwardCount() {
        MonthAward result = new MonthAward();
        //1、获取本月新增奖金
        Double monthGrow = baseMapper.queryMonthGrow(new Date());
        result.setMonthIncreased(monthGrow);

        //2、获取历史奖金金额
        Double awardTotal = baseMapper.queryAllAward(new Date());
        result.setAwardTotal(awardTotal);

        //3、本月累计奖金 =本月新增奖金+上月剩余月度肥料奖金
        //获取上月剩余月度肥料奖金
        Double monthAwardTotal;
        Date date = DateUtil.getLastMonth(new Date());
        String yearMonth = DateUtil.convertDateToStr(date, "yyyy-MM");
        MonthManure monthManure = monthManureMapper.queryByTime(yearMonth);
        if (null == monthManure) {
            monthAwardTotal = monthGrow;
        } else {
            monthAwardTotal = monthGrow + monthManure.getManureAward();
        }
        result.setMonthAwardTotal(monthAwardTotal);

        //4、较上月增长奖金  本月累计奖金-上月累计奖金
        //本月
        String currentMonth=DateUtil.convertDateToStr(new Date(),"yyyy-MM");

        Date lastDate=DateUtil.getLastMonth(new Date());
        String lastMonth=DateUtil.convertDateToStr(lastDate,"yyyy-MM");
        Double growthAward;

        //获取上月 累计奖金
        MonthAward monthAward = monthAwardMapper.getByTime(lastMonth);
        if (null == monthAward) {
            growthAward = monthAwardTotal;
        } else {
            growthAward = monthAwardTotal - monthAward.getMonthAwardTotal();
        }
        result.setGrowthAward(growthAward);

        //5、获取黄金树本月奖金
        Double goldAward = baseMapper.queryByUserLevel(UserLevelEnum.GOLD_TREE.getCode(), new Date());
        if (null == goldAward) {
            result.setGoldAward(0.00);
        } else {
            result.setGoldAward(goldAward);
        }

        //6、获取农场主本月奖金
        Double farmerAward = baseMapper.queryByUserLevel(UserLevelEnum.FARMER.getCode(), new Date());
        if (null == farmerAward) {
            result.setFarmerAward(0.00);
        } else {
            result.setFarmerAward(farmerAward);
        }

        //7、森林之星月奖金
        Double startAward = baseMapper.queryByUserLevel(UserLevelEnum.FOREST_START.getCode(), new Date());
        if (null == startAward) {
            result.setForestStartAward(0.00);
        } else {
            result.setForestStartAward(startAward);
        }

        //8、森田合伙人月奖金
        Double partnerAward = baseMapper.queryByUserLevel(UserLevelEnum.PARTNER.getCode(), new Date());
        if (null == partnerAward) {
            result.setPartnerAward(0.00);
        } else {
            result.setPartnerAward(partnerAward);
        }

        //9、 判断是否有本月奖金这条数据，没有，新增，有更新值
        MonthAward currentMonthAward = monthAwardMapper.getByTime(currentMonth);
        if (null == currentMonthAward) {
            int count = monthAwardMapper.add(result);
            if (count == 0) {
                return R.ok(1, false);
            }
        } else {
            result.setId(currentMonthAward.getId());
            int count = monthAwardMapper.edit(result);
            if (count == 0) {
                return R.ok(1, false);
            }
        }

        return R.ok(0, true);
    }

    @Override
    public R<PageInfo<TradeRecord>> queryList(TradeRecordQuery query) {
        log.info("shop-mall[]TradeRecordServiceImpl[]queryList[]input.param.query:" + query);
        if (null == query) {
            return R.error("入参不能为空!");
        }

        pageHandle(query);

        Map<String, Object> map = new HashMap<>(8);
        map.put("userId", query.getUserId());
        int total = tradeRecordMapper.count(map);

        map.put("startNum", query.getStartNum());
        map.put("endNum", query.getEndNum());
        List<TradeRecord> list = tradeRecordMapper.getList(map);
        PageInfo<TradeRecord> info = new PageInfo<>();
        info.setPageSize(query.getPageSize());
        info.setPageNum(query.getPageNo());
        info.setTotal(total);
        info.setList(list);
        return R.ok(info);
    }

    /**
     * 分页处理方法
     *
     * @param schemeVo 参数
     */
    private void pageHandle(TradeRecordQuery schemeVo) {
        Integer pageNum = schemeVo.getPageNo();
        Integer pageSize = schemeVo.getPageSize();
        if (null == pageSize || pageSize == 0) {
            pageSize = 10;
        }
        if (null == pageNum || pageNum == 0) {
            pageNum = 1;
        }
        Integer endNum = pageSize;
        Integer startNum = (pageNum - CommonAttributes.NUM_ONE) * pageSize;
        schemeVo.setEndNum(endNum);
        schemeVo.setStartNum(startNum);
        schemeVo.setPageNo(pageNum);
        schemeVo.setPageSize(pageSize);
    }
}
