package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.vo.MonthAwardVo;
import cn.wisenergy.service.app.MonthAwardService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author 86187
 * @ Description: 月度奖励
 * @ Author     : 86187
 * @ Date       : 2021/3/9 11:04
 */
@Api(tags = "月度奖励接口")
@RestController
@RequestMapping("/award")
@Slf4j
public class MonthAwardController {
    @Autowired
    private MonthAwardService monthAwardService;

    @ApiOperation(value = "本月累计奖金", notes = "本月累计奖金", httpMethod = "GET")
    @ApiImplicitParam(name = "userId", value = "用户id", dataType = "String")
    @GetMapping("/queryMonthAward")
    public R<MonthAwardVo> queryMonthAward(String userId) {
        log.info("shop-mall[]MonthAwardController[]queryMonthAward[]input.param.userId:" + userId);
        if (StringUtils.isBlank(userId)) {
            return R.error("入参为空!");
        }
        return monthAwardService.queryMonthAward(userId);
    }
}
