package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.service.app.MonthTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author 86187
 */
@Api(tags = "月度任务管理")
@RestController
@RequestMapping("/task")
@Slf4j
public class MonthTaskController {
    @Autowired
    private MonthTaskService monthTaskService;

    @ApiOperation(value = "月度肥料--月定时任务", notes = "月度肥料--月定时任务", httpMethod = "GET")
    @GetMapping("/monthManure")
    public R<Boolean> monthManure() {
        return monthTaskService.performanceCount();
    }

    @ApiOperation(value = "最大进步奖--月定时任务", notes = "最大进步奖--月定时任务", httpMethod = "GET")
    @GetMapping("/growAward")
    public R<Boolean> growAward() {
        return monthTaskService.progressPrizeCount();
    }

    @ApiOperation(value = "账户表镜像", notes = "账户表镜像---每月更新一次，保存上一个的数据", httpMethod = "GET")
    @GetMapping("/mirrorImage")
    public R<String> mirrorImage() {
        monthTaskService.mirrorImage();
        return R.ok("success");
    }


    @ApiOperation(value = "运营中心补贴", notes = "运营中心补贴", httpMethod = "GET")
    @GetMapping("/runCenterSubsidy")
    public R<Boolean> runCenterSubsidy() {
        return monthTaskService.runCenterSubsidy();
    }

}
