package cn.wisenergy.web.admin.controller.app;


import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.TeamPerformance;
import cn.wisenergy.model.dto.TeamQueryDto;
import cn.wisenergy.service.app.TeamPerformanceService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author 86187
 */
@Api(tags = "团队业绩--后台管理")
@RestController
@RequestMapping("/team")
@Slf4j
public class TeamController {
    @Autowired
    private TeamPerformanceService teamPerformanceService;

    @ApiOperation(value = "团队业绩列表", notes = "团队业绩列表", httpMethod = "GET")
    @ApiImplicitParam(name = "query", value = "查询参数", dataType = "TeamQueryDto")
    @GetMapping("/queryList")
    public R<PageInfo<TeamPerformance>> queryList(TeamQueryDto query) {
        log.info("shop-mall[]TeamController[]queryList[]input.param.query:" + query);
        return teamPerformanceService.getList(query);
    }
}
