package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.TradeRecord;
import cn.wisenergy.model.dto.TradeRecordQuery;
import cn.wisenergy.service.app.TradeRecordService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author 86187
 */
@Api(tags = "交易流水-后台管理")
@RestController
@RequestMapping("/trade")
@Slf4j
public class TradeRecordController {
    @Autowired
    private TradeRecordService tradeRecordService;

    @ApiOperation(value = "交易流水列表", notes = "交易流水列表", httpMethod = "GET")
    @ApiImplicitParam(name = "query", value = "查询参数", dataType = "TradeRecordQuery")
    @GetMapping("/queryList")
    public R<PageInfo<TradeRecord>> queryList(TradeRecordQuery query) {
        log.info("shop-mall[]TradeRecordController[]queryList[]input.param.query:" + query);
        return tradeRecordService.queryList(query);
    }

    @ApiOperation(value = "统计月度奖金", notes = "统计月度奖金", httpMethod = "POST")
    @PostMapping("/monthAwardCount")
    public R<Boolean> monthAwardCount() {
        log.info("shop-mall[]TradeRecordController[]monthAwardCount[]input.method");
        return tradeRecordService.monthAwardCount();
    }

}
