package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.model.app.shopZx;
import cn.wisenergy.model.app.zxUserVo;
import cn.wisenergy.service.app.UploadService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;


/**
 * Created by m1991 on 2021/2/24 13:46
 */
@Api(tags = "资讯管理")
@RestController
@RequestMapping("/ZX")
@Slf4j
public class UploadController {

    @Autowired
    private UploadService uploadService;

    @Autowired
    private UserController userController;

    /**
     * @param request
     * @return
     * @throws Exception
     */
    /**
     * 视频文件上传
     * 资讯主键id* 视频/封面存放地址* 用户id(作者id)
     * 获赞数* 视频/图片名称* 审核字段* 资讯文字输入字段
     * 资讯创建时间* 图片储存地址* 资讯发表地址
     *
     * @param file
     * @param request
     * @param zxField
     * @return
     * @throws Exception
     */
    @ApiOperation(value = "资讯信息-文字/视频上传接口", notes = "返回路径给前台", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "zxField", value = "资讯文字", dataType = "String"),
            @ApiImplicitParam(name = "file", value = "视频文件", dataType = "MultipartFile"),
            @ApiImplicitParam(name = "zxAddress", value = "资讯发布地址", dataType = "String"),
            @ApiImplicitParam(name = "inviteCode", value = "用户本人邀请码（发布人）", required = true, dataType = "String")})
    @RequestMapping(value = "/uploadVideo", method = RequestMethod.POST)
    public Map<String, Object> uploadVideo(@RequestParam(value = "files")MultipartFile file, HttpServletRequest request, String zxField, String inviteCode) throws Exception {
        return uploadService.uploadVideo(file, request, zxField,inviteCode);
    }

    /**
     * TODO 用户头像上传/更新头像接口
     *
     * @param
     * @return
     * @throws Exception
     */
    @ApiOperation(value = "用户头像上传接口", notes = "返回路径给前台", httpMethod = "POST", produces = "application/json; charset=UTF-8")
    @ApiImplicitParam(name = "file", value = "单图片", dataType = "MultipartFile")
    @RequestMapping(value = "/uploadImage", method = RequestMethod.POST)
    public Map<String, Object> uploadImage(@RequestParam(value = "files")MultipartFile file,String inviteCode) throws Exception {
        return uploadService.uploadImage(file,inviteCode);
    }


    /**
     * *
     * *  TODO  多文件上传接口
     * *
     * @return
     */
    private static final Logger logger = LoggerFactory.getLogger(UploadController.class);

    @ApiOperation(value = "资讯信息-文字/多图片上传接口", notes = "上传图片,返回路径给前台", httpMethod = "POST", produces = "application/json; charset=UTF-8")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "zxField", value = "资讯文字", dataType = "String"),
            @ApiImplicitParam(name = "files", value = "多图片", paramType = "form", allowMultiple=true, dataType = "__file"),
            @ApiImplicitParam(name = "inviteCode", value = "用户本人邀请码（发布人）", required = true, dataType = "String")})

    @RequestMapping(method = RequestMethod.POST, value = "/multipleImageUpload", headers = "content-type=multipart/form-data")
    public Map multipleImageUpload(@RequestParam(required=false,value = "files") MultipartFile[] files, String zxField, String inviteCode) {
        return uploadService.imageUpload(files, zxField,inviteCode);

    }

    /**
     *  TODO 资讯展示
     * @param pageNum
     * @param pageSize
     * @return
     */
    @ApiOperation(value = "用户发布已审核资讯信息倒叙展示", notes = "倒叙展示", httpMethod = "POST", produces = "application/json; charset=UTF-8")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "从几开始", required = true,dataType = "integer"),
            @ApiImplicitParam(name = "inviteCode", value = "用户本人邀请码（发布人）", required = false, dataType = "String"),
            @ApiImplicitParam(name = "pageSize", value = "一页展示数量", required = true, dataType = "Integger")})
    @RequestMapping(method = RequestMethod.GET, value = "/zxAll")
    public Map selectPage(int pageNum, int pageSize,String inviteCode){

        return uploadService.selectPage(pageNum,pageSize,inviteCode);
    }

    /**
     *  TODO 点赞接口
     */
    @ApiOperation(value = "用户发布资讯信息点赞接口", notes = "点赞接口", httpMethod = "POST", produces = "application/json; charset=UTF-8")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "zxid", value = "资讯ID", required = true,dataType = "integer"),
            @ApiImplicitParam(name = "inviteCode", value = "用户本人邀请码（发布人）", required = true, dataType = "String")})
    @RequestMapping(method = RequestMethod.POST, value = "/thumbUp")
    public Map like(int zxid,String inviteCode){
        return uploadService.Ilike(zxid,inviteCode);
    }

    /**
     *  TODO 审核接口
     */
    @ApiOperation(value = "用户发布资讯信息审核接口", notes = "审核接口",produces = "application/json; charset=UTF-8")
    @ApiImplicitParam(name = "zxid", value = "资讯ID", required = true,dataType = "integer")
    @RequestMapping(method = RequestMethod.POST, value = "/toExamine")
    public Map ToExamine(int zxid){

        return uploadService.toExamine(zxid);
    }

    /**
     *  TODO 查询资讯单表全部数据的API
     */
    @ApiOperation(value = "查询资讯单表全部数据的API", notes = "单表全部数据的API")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "从几开始", required = true,dataType = "int"),
            @ApiImplicitParam(name = "pageSize", value = "一页展示数量", required = true, dataType = "int")})
    @RequestMapping(method = RequestMethod.GET, value = "/shopzxAll")
    public List<zxUserVo> shopzxAll(Integer pageNum, Integer pageSize){
        return uploadService.selectAll(pageNum,pageSize);
    }
}