package cn.wisenergy.web.common;

import cn.wisenergy.model.app.User;
import cn.wisenergy.service.app.UserService;
import cn.wisenergy.web.shiro.JwtUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;

/**
 * 控制器基类
 *
 * @author wyy
 * @date 2019年08月15日
 */
@Slf4j
public abstract class BaseController {

    @Autowired
    private UserService authUserService;
    @Autowired
    JwtUtil jwtUtil;
    @Autowired
    HttpServletRequest request;

    /**
     * 获取当前登录用户
     *
     * @return
     */
    public User getUser() {
        return (User) SecurityUtils.getSubject().getPrincipal();
    }


    protected <T> Page<T> getPage(int size) {
        int _size = size, _index = 1;
        if (request.getParameter("_size") != null) {
            _size = Integer.parseInt(request.getParameter("_size"));
        }
        if (request.getParameter("_index") != null) {
            _index = Integer.parseInt(request.getParameter("_index"));
        }
        return new Page<T>(_index, _size);
    }
}