package cn.wisenergy.common.utils;

/***
 * 系统中保存的一些常量
 */
/**
 * Created by m1991 on 2021/2/28 22:50
 */
public class Constants {
    //通用常量
    public static class Common{
        //否
        public final static Integer NOT = 0;
        //是
        public final static Integer YES = 1;
        //女
        public final static Integer SEX_WOMEN = 0;
        //男
        public final static Integer SEX_MAN = 1;
        //数据精度
        public final static Integer DECIMAL_DIGITS = 2;
    }
    //访问来源
    public static class SourceType{
        //访问来源-APP
        public final static Integer APP = 0;
        //访问来源-PC
        public final static Integer PC = 1;
    }
    //连接符
    public static class Connnector{
        //逗号
        public final static String COMMA_ = ",";
        //下划线
        public final static String UNDERLINE = "_";
        //冒号
        public final static String COLON=":";
    }
    //时长
    public static class Duration{
        //一秒
        public final static Integer SECOND_INT = 1;
        //一分钟
        public final static Integer MINUTE_INT = SECOND_INT * 180;
        //半小时
        public final static Integer HALF_HOUR_INT = MINUTE_INT * 30;
    }
    //正则的一些常量
    public static class RegConstant{
        //手机号正则
        public static String PHONE_REGSTR = "^1[0-9]{10}$";
        //密码正则
        public static String PASSWORD_REGSTR = "^([A-Z]|[a-z]|[0-9]|[_]){6,10}$";
    }
    //SMS相关常量
    public static class Sms{
        public static class TemplateCode{
            //对存入redis的tokn用户进行标注
            public static String LOGIN_BZ_REGISTER="xts";
            //身份验证验证码
            public static String LOGIN_SF_REGISTER="SMS_212170059";
            //登录确认验证码
            public static String LOGIN_DL_REGISTER="SMS_212170058";
            //登录异常验证码
            public static String LOGIN_DLYC_REGISTER="SMS_212170057";
            //用户注册验证码
            public static String LOGIN_ZC_REGISTER="SMS_212170056";
            //修改密码验证码
            public static String LOGIN_XGMM_REGISTER= "SMS_212170055";
           // 信息变更验证码
            public static String LOGIN_XXBG_REGISTER= "SMS_212170054";

        }

        public static class CodeType{
            public static Integer LOGIN_OR_REGISTER=0;
            public static Integer PASS_UPDATE=1;
            public static Integer ORDER_NOTICE=2;
        }
    }
    //RedisKey相关的常量
    public static class RedisKey{
        public static String PROJECT_PRIFIX="xts";
        public static String SMS_PRIFIX="sms";
        public static String TOKEN_PRIFIX="token";
        public static String BANK_PRIFIX="bank";
    }
}
