package cn.wisenergy.common.utils;

import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ImageUtil {

    /**
     * JAVA添加文字水印
     *
     * @param srcImage   目标图片
     * @param waterImage 水印图片
     * @return
     */
    public static byte[] watermarkImageSimple1(BufferedImage srcImage, BufferedImage waterImage) throws IOException {
        int bgWidth = srcImage.getWidth(null);
        int bgHeight = srcImage.getHeight(null);
        BufferedImage image = new BufferedImage(bgWidth, bgHeight, BufferedImage.TYPE_INT_RGB);
        Graphics2D g = image.createGraphics();
        g.drawImage(srcImage, 0, 0, bgWidth, bgHeight, null);
        g.drawImage(waterImage, bgWidth - 150, bgHeight - 150, waterImage.getWidth(), waterImage.getHeight(), null);
        g.dispose();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write(image, "jpg", out);
        return out.toByteArray();
    }

    /**
     * JAVA添加文字水印
     *
     * @param srcImage   目标图片
     * @param waterImage 水印图片
     * @return
     */
    public static byte[] watermarkImageSimple(BufferedImage srcImage, BufferedImage waterImage) {
        Graphics2D graphics = srcImage.createGraphics();
        graphics.drawImage(waterImage, srcImage.getWidth() - 100, 0, waterImage.getWidth(), waterImage.getHeight(), null);
        graphics.dispose();

        ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
        ImageWriteParam imgWriteParams = new javax.imageio.plugins.jpeg.JPEGImageWriteParam(null);
        imgWriteParams.setCompressionMode(ImageWriteParam.MODE_DISABLED);
        //imgWriteParams.setCompressionQuality(1.0f);
        imgWriteParams.setProgressiveMode(ImageWriteParam.MODE_DISABLED);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IIOImage iIamge = new IIOImage(waterImage, null, null);
        try {
            writer.setOutput(ImageIO.createImageOutputStream(baos));
            writer.write(null, iIamge, imgWriteParams);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    /**
     * JAVA添加文字水印
     *
     * @param srcImage   目标图片
     * @param waterImage 水印图片
     * @return
     */
    public static byte[] watermarkImageSimple(byte[] srcImage, byte[] waterImage) throws IOException {
        //使用ImageIO的read方法读取图片
        ByteArrayInputStream srcImageStream = new ByteArrayInputStream(srcImage);
        BufferedImage read = ImageIO.read(srcImageStream);

        ByteArrayInputStream waterImageStream = new ByteArrayInputStream(srcImage);
        BufferedImage image = ImageIO.read(waterImageStream);
        Graphics2D graphics = read.createGraphics();
        graphics.drawImage(image, read.getWidth() - 100, 0, image.getWidth(), image.getHeight(), null);
        graphics.dispose();

        ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
        ImageWriteParam imgWriteParams = new javax.imageio.plugins.jpeg.JPEGImageWriteParam(null);
        imgWriteParams.setCompressionMode(ImageWriteParam.MODE_DISABLED);
        //imgWriteParams.setCompressionQuality(1.0f);
        imgWriteParams.setProgressiveMode(ImageWriteParam.MODE_DISABLED);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IIOImage iIamge = new IIOImage(image, null, null);
        try {
            writer.setOutput(ImageIO.createImageOutputStream(baos));
            writer.write(null, iIamge, imgWriteParams);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }


    /**
     * JAVA添加文字水印
     *
     * @param srcImage   目标图片
     * @param waterImage 水印图片
     * @param x          水印图片距离目标图片左侧的偏移量，如果x<0, 则在正中间
     * @param y          水印图片距离目标图片上侧的偏移量，如果y<0, 则在正中间
     * @param alpha      透明度(0.0 -- 1.0, 0.0为完全透明，1.0为完全不透明)
     * @param degree     水印图片旋转角度
     * @return
     */
    public static byte[] watermarkImage(byte[] srcImage, byte[] waterImage, int x, int y, float alpha, Integer degree) throws IOException {
        //使用ImageIO的read方法读取图片
        ByteArrayInputStream srcImageStream = new ByteArrayInputStream(srcImage);
        BufferedImage read = ImageIO.read(srcImageStream);
        ByteArrayInputStream waterImageStream = new ByteArrayInputStream(srcImage);
        BufferedImage image = ImageIO.read(waterImageStream);

        //获取画布
        Graphics2D graphics = read.createGraphics();
        //设置透明度为0.5
        graphics.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_ATOP, 1.0f));
        //添加水印
        if (x == 0) {
            x = read.getWidth() - 100;
        }
        graphics.drawImage(image, x, 0, image.getWidth(), image.getHeight(), null);
        //关闭透明度
        //graphics.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER));
        graphics.dispose();

        // 开始打包图片，写入byte[] 取得内存输出流 指定写图片的方式为jpg
        ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
        ImageWriteParam imgWriteParams = new javax.imageio.plugins.jpeg.JPEGImageWriteParam(null);
        // 要使用压缩，必须指定压缩方式为MODE_EXPLICIT
        imgWriteParams.setCompressionMode(ImageWriteParam.MODE_EXPLICIT);
        // 这里指定压缩的程度，参数qality是取值0~1范围内，
        imgWriteParams.setCompressionQuality(1.0f);
        imgWriteParams.setProgressiveMode(ImageWriteParam.MODE_DISABLED);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IIOImage iIamge = new IIOImage(image, null, null);
        try {
            // 此处因为ImageWriter中用来接收write信息的output要求必须是ImageOutput
            // 通过ImageIo中的静态方法，得到byteArrayOutputStream的ImageOutput
            writer.setOutput(ImageIO.createImageOutputStream(baos));
            writer.write(null, iIamge, imgWriteParams);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    /**
     * @param srcFile 原图路径
     * @return
     * @throws IOException
     */
    public static byte[] compressPic(byte[] srcFile, float quality) throws IOException {
        // 指定写图片的方式为 jpg
        ImageWriter writer = ImageIO.getImageWritersByFormatName("jpg").next();
        ImageWriteParam imgWriteParams = new javax.imageio.plugins.jpeg.JPEGImageWriteParam(null);
        // 要使用压缩，必须指定压缩方式为MODE_EXPLICIT
        imgWriteParams.setCompressionMode(ImageWriteParam.MODE_EXPLICIT);
        // 这里指定压缩的程度，参数qality是取值0~1范围内，
        imgWriteParams.setCompressionQuality(quality);
        imgWriteParams.setProgressiveMode(ImageWriteParam.MODE_DISABLED);

        ByteArrayInputStream in = new ByteArrayInputStream(srcFile);
        BufferedImage image = ImageIO.read(in);
        // ColorModel.getRGBdefault();
        ColorModel colorModel = image.getColorModel();
        imgWriteParams.setDestinationType(new javax.imageio.ImageTypeSpecifier(colorModel, colorModel.createCompatibleSampleModel(16, 16)));

        // 开始打包图片，写入byte[]
        // 取得内存输出流
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IIOImage iIamge = new IIOImage(image, null, null);
        try {
            // 此处因为ImageWriter中用来接收write信息的output要求必须是ImageOutput
            // 通过ImageIo中的静态方法，得到byteArrayOutputStream的ImageOutput
            writer.setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
            writer.write(null, iIamge, imgWriteParams);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

}
