package cn.wisenergy.mapper;

import cn.wisenergy.model.app.LastMonthAccount;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

public interface LastAccountMapper extends BaseMapper<LastMonthAccount> {

    /**
     * 通过userId 和 yearMonth获取账户信息
     *
     * @param userId    用户id
     * @param yearMonth 年月
     * @return 账户信息
     */
    LastMonthAccount getByUserIdAndTime(@Param("userId") String userId, @Param("yearMonth") String yearMonth);

    /**
     * 把 A 表的结构数据 复制给 B表
     *
     * @param oldTable A
     * @param newTable B
     */
    void copyTable(@Param("oldTable") String oldTable, @Param("newTable") String newTable);

    /**
     * 删除表
     *
     * @param tableName 表名
     */
    void deleteTable(@Param("tableName") String tableName);

    /**
     * 更新表名
     *
     * @param oldTableName 旧表名
     * @param newTableName 新表名
     */
    void updateTableName(@Param("oldTableName") String oldTableName, @Param("newTableName") String newTableName);
}
