package cn.wisenergy.mapper;

import cn.wisenergy.model.app.MonthManure;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

/**
 * @author 86187
 */
public interface MonthManureMapper extends BaseMapper<MonthManure> {
    /**
     * 添加月度肥料
     *
     * @param monthManure 月度肥料信息
     * @return 1
     */
    int add(MonthManure monthManure);

    /**
     * 编辑月度肥料
     *
     * @param monthManure 月度肥料信息
     * @return 1
     */
    int edit(MonthManure monthManure);

    /**
     * 通过年月获取月度肥料剩余奖金信息
     *
     * @param yearMonth 年月
     * @return 月度肥料剩余奖金信息
     */
    MonthManure queryByTime(@Param("yearMonth") String yearMonth);
}
