package cn.wisenergy.model.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author 86187
 * @ Description:  银行卡信息实体类
 * @ Author     : 86187
 * @ Date       : 2021/3/3 15:55
 */
@Data
@ApiModel("BankInfo")
public class BankInfo {

    /**
     * 主键id
     */
    @ApiModelProperty(value = "主键id", name = "id")
    private Integer id;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", name = "userId")
    private String userId;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名", name = "name")
    private String name;

    /**
     * 银行卡名称
     */
    @ApiModelProperty(value = "银行卡名称", name = "bankName")
    private String bankName;

    /**
     * 银行卡卡号
     */
    @ApiModelProperty(value = "银行卡卡号", name = "cardNumber")
    private String cardNumber;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", name = "createTime")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间", name = "updateTime")
    private Date updateTime;

}
