package cn.wisenergy.model.app;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author 86187
 * @ Description   :  用户实体类
 * @ Author        :  lcc
 * @ CreateDate    :  2020/11/8 19:59
 */
@Data
@ApiModel(value = "User")
@TableName("user_info")
public class User extends Model<User> implements Serializable{
    private static final long serialVersionUID = 2525339404301884673L;

    /**
     * 主键id
     */
    @ApiModelProperty(name = "id", value = "用户主键id")
    private Integer id;


    /**
     * 手机号作为用户账号
     */
    @ApiModelProperty(name = "user_id", value = "用户id")
    private String userId;

    /**
     * 密码
     */
    @ApiModelProperty(name = "password", value = "用户密码")
    private String password;

    /**
     * 用户头像
     */
    @ApiModelProperty(name = "用户头像", value = "headImage")
    private String headImage;


    /**
     * 用户会员等级
     */
    @ApiModelProperty(name = "user_level", value = "用户会员等级")
    private int userLevel;

    /**
     * 跨境额度
     */
    @ApiModelProperty(name = "cross_border_line", value = "跨境额度")
    private BigDecimal crossBorderLine;

    /**
     * 身份证号码
     */
    @ApiModelProperty(name = "id_card_number", value = "身份证号码")
    private String idCardNumber;

    /**
     * 粉丝昵称
     */
    @ApiModelProperty(name = "fans_nickname", value = "粉丝昵称")
    private String fansNickname;

    /**
     * 有赞粉丝id，有赞自动生成
     */
    @ApiModelProperty(name = "fans_id", value = "有赞粉丝id，有赞自动生成")
    private String fansId;

    /**
     * 用户本人邀请码
     */
    @ApiModelProperty(name = "invite_code", value = "用户本人邀请码")
    private String inviteCode;

    /**
     * 推荐人邀请码
     */
    @ApiModelProperty(name = "be_invited_code", value = "推荐人邀请码")
    private String beInvitedCode;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;
    /**
     * 修改时间
     */
    @ApiModelProperty(name = "updateTime", value = "修改时间")
    private Date updateTime;
}
