package cn.wisenergy.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author 86187
 * @ Description: 钱包
 * @ Author     : 86187
 * @ Date       : 2021/3/2 10:59
 */
@Data
@ApiModel("MoneyPackageVo")
public class MoneyPackageVo {
    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", name = "userId")
    private String userId;

    /**
     * 本月收益
     */
    @ApiModelProperty(value = "本月收益", name = "moneyIncome")
    private BigDecimal moneyIncome;

    /**
     * 本月可提现
     */
    @ApiModelProperty(value = "本月可提现", name = "currentMoneyCan")
    private BigDecimal currentMoneyCan;

    /**
     * 累计收益
     */
    @ApiModelProperty(value = "累计收益", name = "totalIncome")
    private BigDecimal totalIncome;
}
