package cn.wisenergy.service.app;


import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.AccountInfo;
import cn.wisenergy.model.app.OrderInfo;
import cn.wisenergy.model.app.User;

import java.util.List;

/**
 * @author 86187
 */
public interface AccountService {

    /**
     * 订单返佣-日任务
     * @return true or false
     */
    R<Boolean> orderRebate();

    /**
     * 获取账户信息
     *
     * @param userId 用户id
     * @return 账户信息
     */
    R<AccountInfo> getByUserId(String userId);

    /**
     * 收益和业绩统计（月度肥料 -日）
     *
     * @param list 订单信息
     * @return true or false
     */
    R<Boolean> performanceCount(List<OrderInfo> list);

    /**
     * 获取用户的商机信息
     *
     * @param userId 用户id
     * @return 用户商机列表
     */
    List<User> getByList(String userId);


    /**
     * 进步奖收益统计（最大进步奖） -日任务
     *
     * @return true or false
     */
    R<Boolean> progressPrizeCount();
}
