package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.vo.*;

import java.util.List;

/**
 * @author 86187
 * @ Description: 钱包相关接口定义
 * @ Author     : 86187
 * @ Date       : 2021/3/2 14:33
 */
public interface WalletService {
    /**
     * 用户当月总收益
     *
     * @param userId 用户id
     * @return 当月总收益
     */
    R<MoneyPackageVo> getMoneyPackage(String userId);

    /**
     * 获取用户钱包-可提现
     *
     * @param userId 用户id
     * @return 钱包-可提现
     */
    R<WithdrawalAmountVo> getWithdrawalAmount(String userId);

    /**
     * 展示用户累计收益记录 -最近六月 不包括本月
     *
     * @param userId 用户id
     * @return 用户累计收益
     */
    R<List<AccumulatedIncomeVo>> showIncomeRecord(String userId);

    /**
     * 用户当月总收益
     *
     * @param userId 用户id
     * @return 当月总收益
     */
    R<MoneyPackageDetailVo> queryIncomeDetail(String userId);

    /**
     * 获取提现记录   userId 为空  查全部 不为空，查当前用户
     *
     * @param userId    用户唯一标识
     * @param yearMonth 年月
     * @return 提现记录列表
     */
    R<List<WithdrawalRecordVo>> getWithdrawalRecord(String userId, String yearMonth);


}
