package cn.wisenergy.service.app.impl;

import cn.wisenergy.mapper.TeamUserInfoMapper;
import cn.wisenergy.model.app.TeamUserInfo;
import cn.wisenergy.service.app.TeamUserInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class TeamUserInfoServiceImpl implements TeamUserInfoService {

    @Autowired
    TeamUserInfoMapper teamUserInfoMapper;

    /**
     * 根据用户id获取用户的团队信息
     * @param userId
     * @return
     */
    @Override
    public TeamUserInfo getOneById(String userId) {
        TeamUserInfo byUserId = teamUserInfoMapper.getByUserId(userId);
        return byUserId;
    }

    /**
     * 获取团队总人数
     * @param userId 用户Id
     * @return 用户团队总人数
     */
    @Override
    public int getTeamUserCount(String userId){

        int teamUserCount = teamUserInfoMapper.getTeamUserCount(userId);
        return teamUserCount;
    }
}
