package cn.wisenergy.common.constant;

/**
 * redis 常量
 */
public class RedisConsts {
	/****************************** 后台管理端缓存设置开始 ******************************/
	// 系统setting
	public static final String SYSTEM_SETTING = "system:setting:setting";
	// 接口Token参数设置
	public final static String ADMIN_ACCTNAME = "admin:acctName:";
	public final static int ADMIN_ACCTNAME_EXPIRE = 60 * 60 * 24 * 30;
	/****************************** 后台管理端缓存设置结束 ******************************/

	/************************** shiro 设置开始 ******************************** */
	// shiroSession的redis-key
	public static final String ADMIN_SHIRO_SESSION_KEY = "admin:shiro_redis_session:";
	// shiroSession的过期时间，单位：秒，此值须大于spring-cache.xml中的全局session有效期
	public static final int ADMIN_SHIRO_SESSION_EXPIRE = 3600;
	// shiroRealm的redis-key
	public static final String ADMIN_SHIRO_REALM_KEY = "admin:shiro_redis_realm:";
	// shiroRealm的过期时间，单位：秒，设置与SHIRO_SESSION_EXPIRE相等
	public static final int ADMIN_SHIRO_REALM_EXPIRE = 3600;
	/************************** shiro 设置结束 ******************************** */

	public static final String JWT_ACCESS_TOKEN = "jwt_access_token_";

}
