package cn.wisenergy.model.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * @author zw
 * @ Description:  培育奖记录
 * @ Author     : zw
 * @ Date       : 2021/3/5 14:12
 */
@Data
@ApiModel(value = "CultivatingPrizeInfo")
public class CultivatingPrizeInfo implements Serializable {
    private static final long serialVersionUID = 8336018752382673469L;

    /**
     * 主键id
     */
    @ApiModelProperty(name = "id", value = "主键id")
    private int id;

    /**
     * 用户id
     */
    @ApiModelProperty(name = "userId", value = "用户id")
    private String userId;

    /**
     * 幼苗状态培育奖记录 0：表示上级用户没有获得过当前等级的培育奖
     *                  1： 表示上级用户已经获得过当前等级的培育奖
     */
    @ApiModelProperty(name = "seedling", value = "幼苗等级培育奖记录")
    private int seedling;

    /**
     * 青铜树等级培育奖记录0：表示上级用户没有获得过当前等级的培育奖
     *                 1： 表示上级用户已经获得过当前等级的培育奖
     */
    @ApiModelProperty(name = "bronze_tree", value = "青铜树等级培育奖记录")
    private int bronzeTree;

    /**
     * 白银树等级培育奖记录0：表示上级用户没有获得过当前等级的培育奖
     *                 1： 表示上级用户已经获得过当前等级的培育奖
     */
    @ApiModelProperty(name = "silver_tree", value = "白银树等级培育奖记录")
    private int silverTree;

    /**
     * 黄金树等级培育奖记录0：表示上级用户没有获得过当前等级的培育奖
     *                 1： 表示上级用户已经获得过当前等级的培育奖
     */
    @ApiModelProperty(name = "gold_tree", value = "黄金树等级培育奖记录")
    private int goldTree;

    /**
     * 农场主等级培育奖记录0：表示上级用户没有获得过当前等级的培育奖
     *                   1： 表示上级用户已经获得过当前等级的培育奖
     */
    @ApiModelProperty(name = "forest_start", value = "农场主等级培育奖记录")
    private int farmer;

    /**
     * 森林之星等级培育奖记录0：表示上级用户没有获得过当前等级的培育奖
     *                   1： 表示上级用户已经获得过当前等级的培育奖
     */
    @ApiModelProperty(name = "forest_start", value = "森林之星等级培育奖记录")
    private int forestStart;

    /**
     * 西田森合伙人等级培育奖记录0：表示上级用户没有获得过当前等级的培育奖
     *                      1： 表示上级用户已经获得过当前等级的培育奖
     */
    @ApiModelProperty(name = "partner", value = "西田森合伙人等级培育奖记录")
    private int partner;

    /**
     * 创建时间
     */
    @ApiModelProperty(name = "createTime", value = "创建时间")
    private Date createTime;

    /**
     * 修改时间
     */
    @ApiModelProperty(name = "updateTime", value = "修改时间")
    private Date updateTime;

}
