package cn.wisenergy.model.enums;

/**
 * @author 86187
 * @ Description: 会员收益比例类型枚举
 * @ Author     : 86187
 * @ Date       : 2021/3/8 16:54
 */
public enum MemberPercentEnum {
    /**
     * 会员收益比例类型枚举 1：返佣 2：月度肥料 3：月度最大进步奖 4：运营中心补贴
     */
    REBATE(1, "返佣"),
    MONTH_MANURE(2, "月度肥料"),
    MONTH_BEST_AWARD(3, "月度最大进步奖"),
    RUN_CENTER_SUBSIDY(4, "运营中心补贴");

    MemberPercentEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private Integer code;

    private String desc;

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
