package cn.wisenergy.model.enums;

/**
 * @author 86187
 * @ Description: 交易记录类型枚举
 * @ Author     : 86187
 * @ Date       : 2021/3/1 14:27
 */
public enum TradeRecordEnum {
    /**
     * 交易记录类型
     */
    WITHDRAW_DEPOSIT(1, "提现"),

    ORDER_REBATE(2, "订单返佣"),

    PLACE_ORDER(3, "订单下单"),

    MONTHLY_FERTILIZER(4, "月度肥料"),

    CULTIVATING_PRIZE(5, "培育奖"),

    SALARY_REWARD(6, "工资奖励"),

    PROGRESS_PRIZE(7, "最大进步奖");
    private Integer code;

    private String desc;

    TradeRecordEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static String getByCode(Integer code) {
        if (null == code) {
            return null;
        }

        for (TradeRecordEnum operation : TradeRecordEnum.values()) {
            if (operation.getCode().intValue() == code.intValue()) {
                return operation.getDesc();
            }
        }
        return null;
    }
}
