package cn.wisenergy.model.enums;

/**
 * @author 86187
 * @ Description: 交易状态枚举
 * @ Author     : 86187
 * @ Date       : 2021/3/3 10:53
 */
public enum TradeStatusEnum {
    /**
     * 交易状态
     */
    NO_SETTLE_ACCOUNTS(0, "未结算"),
    ALREADY_SETTLE_ACCOUNTS(1, "已结算"),
    BANK_TRANSFER_ACCOUNTS(2, "银行转账中"),
    WITHDRAWAL_SUCCESS(3, "提现成功");
    private Integer code;

    private String desc;

    TradeStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
