package cn.wisenergy.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author 86187
 * @ Description: 钱包可提现Vo
 * @ Author     : 86187
 * @ Date       : 2021/3/2 16:10
 */
@Data
@ApiModel("WithdrawalAmountVo")
public class WithdrawalAmountVo {

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", name = "userId")
    private String userId;

    /**
     * 上月未提
     */
    @ApiModelProperty(value = "上月未提", name = "lastMoneyNot")
    private BigDecimal lastMoneyNot;

    /**
     * 本月可提现
     */
    @ApiModelProperty(value = "本月可提现", name = "currentMoneyCan")
    private BigDecimal currentMoneyCan;


    /**
     * 提现规则
     */
    @ApiModelProperty(value = "提现规则", name = "withdrawRule")
    private String withdrawRule;


}
