package cn.wisenergy.service.app.impl;

import cn.wisenergy.common.utils.DateUtil;
import cn.wisenergy.mapper.*;
import cn.wisenergy.model.app.RecommendUser;
import cn.wisenergy.model.app.TeamPerformance;
import cn.wisenergy.model.app.TeamUserInfo;
import cn.wisenergy.service.app.UserForestStatusService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.xml.ws.soap.Addressing;
import java.math.BigDecimal;
import java.sql.Time;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 用户森林状态
 * @author 86187
 */
@Service
@Slf4j
public class UserForestStatusServiceImpl implements UserForestStatusService {

    @Autowired
    UsersMapper usersMapper;

    @Autowired
    RecommendUserMapper recommendUserMapper;

    @Autowired
    TeamUserInfoMapper teamUserInfoMapper;

    @Autowired
    TeamPerformanceMapper teamPerformanceMapper;

    @Autowired
    OrderMapper orderMapper;
    /**
     * 根据用户id获取用户森林状态
     * @param userId
     * @return
     */

    //todo：团队当月新增业绩
    @Override
    public Map getUserForestStatus(String userId) {

        //用户升级条件
        BigDecimal levelTerm = new BigDecimal(3980);

        HashMap<Object, Object> userForestStatusMap = new HashMap<>();
        HashMap<Object, Object> difference = new HashMap<>();

        String date = DateUtil.convertDateToStr(new Date(), "yyyy-MM");
        //1.获取当前用户的等级
        Integer userLevel = usersMapper.getByUserId(userId).getUserLevel();
        //2.获取当前用户的直推总人数
        Integer recommendUserCountByUserId = recommendUserMapper.getRecommendUserCountByUserId(userId);
        //3.获取当前用户的团队总人数
        Integer teamUserCount = teamUserInfoMapper.getTeamUserCount(userId);
        //4.团队累计总业绩
        Double teamCountDouble = teamPerformanceMapper.countUserTeamByUserId(userId);
        //5.团队当月新增业绩
        Double teamNowCount = teamPerformanceMapper.monthUserTeamByuserId(userId,date);
        //用户直推表信息
        RecommendUser recommendUserMapperByUserId = recommendUserMapper.getByUserId(userId);
        //用户团队表信息
        TeamUserInfo teamUserInfobyUserId = teamUserInfoMapper.getByUserId(userId);

        //6.距离下级升级条件
        if(userLevel == 0){
            //用户等级 < 幼苗 显示业绩缺少额度
            //获取当前用户的业绩
            BigDecimal performanceByUserid = orderMapper.getPerformanceByUserid(userId);
            if (performanceByUserid == null){
                performanceByUserid = new BigDecimal(0);
            }
            //距离升级还差多少额度
            BigDecimal differenceAmount = levelTerm.subtract(performanceByUserid);
            difference.put("differenceAmount",differenceAmount);
            userForestStatusMap.put("differenceMap",difference);
        }else if(userLevel == 1){
            //用户等级为幼苗
            //到达青铜树升级条件
            int recommendSeedling = 5;
            //获取当前用户直接推荐表中幼苗数量
            Integer recommendseedlingNum = recommendUserMapperByUserId.getSeedlingNum();
            //距离升级还差  recommendDifferenceSeedling
            int recommendDifferenceSeedling =  recommendSeedling - recommendseedlingNum;
            if (recommendDifferenceSeedling < 0){
                recommendDifferenceSeedling = 0;
            }
            difference.put("recommendDifferenceSeedling",recommendDifferenceSeedling);
            //距离升级所差百分比
            float perenctFloat = ((float)recommendseedlingNum / recommendSeedling);
            float perpenct = (float) Math.round(perenctFloat*100)/100;
            userForestStatusMap.put("perenct",perpenct);
            userForestStatusMap.put("differenceMap",difference);
        }
        else if (userLevel == 2){
            //用户等级为青铜树
            //到达白银树升级条件
            int recommendSeedling = 20;
            //获取当前用户直接推荐表中幼苗数量
            Integer recommendseedlingNum = recommendUserMapperByUserId.getSeedlingNum();
            //距离升级还差  recommendDifferenceSeedling
            int recommendDifferenceSeedling =  recommendSeedling - recommendseedlingNum;
            if (recommendDifferenceSeedling < 0){
                recommendDifferenceSeedling = 0;
            }
            difference.put("recommendDifferenceSeedling",recommendDifferenceSeedling);
            //距离升级所差百分比
            float perenctFloat = ((float)recommendseedlingNum / recommendSeedling);
            float perpenct = (float) Math.round(perenctFloat*100)/100;
            userForestStatusMap.put("perenct",perpenct);
            userForestStatusMap.put("differenceMap",difference);
        }else if (userLevel == 3){
            //用户等级为白银树

            //黄金升级条件
            int recommendSeedling = 50;
            int recommendSilver = 4;
            int teamBronze = 20;

            //当前用户直推表
            int seedlingNum = recommendUserMapperByUserId.getSeedlingNum();
            Integer silverTreeNum = recommendUserMapperByUserId.getSilverTreeNum();
            Integer teamBronzeTreeNum = teamUserInfobyUserId.getBronzeTreeNum();
            //直推幼苗差
            //直推白银差
            //团队青铜差
            int recommendDifferenceSeedling = recommendSeedling - seedlingNum;
            if(recommendDifferenceSeedling < 0 ){
                recommendDifferenceSeedling = 0;
            }
            int recommendDifferenceSilver = recommendSilver - silverTreeNum;
            if (recommendDifferenceSilver < 0){
                recommendDifferenceSilver = 0;
            }
            int teamDifferenceBronze = teamBronze - teamBronzeTreeNum;
            if (teamDifferenceBronze < 0 ){
                teamDifferenceBronze = 0;
            }
            //距离升级所差百分比
            float perenctFloat = ((float) (seedlingNum + silverTreeNum + teamBronzeTreeNum)
                    / (recommendSeedling + recommendSilver + teamBronze));
            float perenct = (float) Math.round(perenctFloat*100)/100;
            userForestStatusMap.put("perenct",perenct);
            difference.put("recommendDifferenceSeedling",recommendDifferenceSeedling);
            difference.put("recommendDifferenceSilver",recommendDifferenceSilver);
            difference.put("teamDifferenceBronze",teamDifferenceBronze);
            userForestStatusMap.put("differenceMap",difference);

        }else if (userLevel == 4){
            //用户等级为黄金树

            //农场主升级条件
            int recommendSeedling = 70;
            int recommendGold = 3;
            int teamSilver = 40;

            int recommendSeedlingNum = recommendUserMapperByUserId.getSeedlingNum();
            int recommendGoldTreeNum = recommendUserMapperByUserId.getGoldTreeNum();
            int teamSilverTreeNum = teamUserInfobyUserId.getSilverTreeNum();

            //直推幼苗差
            //直推黄金差
            //团队白银差
            int recommendDifferenceSeedling = recommendSeedling - recommendSeedlingNum;
            if(recommendDifferenceSeedling < 0 ){
                recommendDifferenceSeedling = 0;
            }
            int recommendDifferenceGold = recommendGold - recommendGoldTreeNum;
            if (recommendDifferenceGold < 0){
                recommendDifferenceGold = 0;
            }
            int teamDifferenceSilver = teamSilver - teamSilverTreeNum;
            if (teamDifferenceSilver < 0 ){
                teamDifferenceSilver = 0;
            }
            //距离升级所差百分比
            float perenctFloat = ((float) (recommendSeedlingNum + recommendGoldTreeNum + teamSilverTreeNum)
                    / (recommendSeedling + recommendGold + teamSilver));
            float perenct = (float) Math.round(perenctFloat*100)/100;
            userForestStatusMap.put("perenct",perenct);
            difference.put("recommendDifferenceSeedling",recommendDifferenceSeedling);
            difference.put("recommendDifferenceGold",recommendDifferenceGold);
            difference.put("teamDifferenceSilver",teamDifferenceSilver);
            userForestStatusMap.put("differenceMap",difference);

        }else if (userLevel == 5){
            //用户等级为农场主

            //升级森林之星条件
            int recommendSeedling = 80;
            int recommenFarmer = 5;
            int teamSilver = 70;
            int teamGold = 30;

            //当前用户条件
            Integer recommendSeedlingNum = recommendUserMapperByUserId.getSeedlingNum();
            Integer recommendFarmerNum = recommendUserMapperByUserId.getFarmerNum();
            Integer teamSilverTreeNum = teamUserInfobyUserId.getSilverTreeNum();
            Integer teamGoldTreeNum = teamUserInfobyUserId.getGoldTreeNum();

            //直推幼苗差
            //直推农场主差
            //团队白银差
            //团队黄金差
            int recommendDifferenceSeedling = recommendSeedling - recommendSeedlingNum;
            if(recommendDifferenceSeedling < 0 ){
                recommendDifferenceSeedling = 0;
            }
            int recommendDifferenceFarmer = recommenFarmer - recommendFarmerNum;
            if (recommendDifferenceFarmer < 0){
                recommendDifferenceFarmer = 0;
            }
            int teamDifferenceSilver = teamSilver - teamSilverTreeNum;
            if (teamDifferenceSilver < 0 ){
                teamDifferenceSilver = 0;
            }
            int teamDifferenceGold = teamGold - teamGoldTreeNum;
            if (teamDifferenceGold < 0 ){
                teamDifferenceGold = 0;
            }
            //距离升级所差百分比
            float perenctFloat = ((float) (recommendSeedlingNum + recommendFarmerNum + teamSilverTreeNum + teamGoldTreeNum)
                    / (recommendSeedling + recommenFarmer + teamSilver + teamGold));
            float perenct = (float) Math.round(perenctFloat*100)/100;
            userForestStatusMap.put("perenct",perenct);
            difference.put("recommendDifferenceSeedling",recommendDifferenceSeedling);
            difference.put("recommendDifferenceFarmer",recommendDifferenceFarmer);
            difference.put("teamDifferenceSilver",teamDifferenceSilver);
            difference.put("teamDifferenceGold",teamDifferenceGold);
            userForestStatusMap.put("differenceMap",difference);

        }else if (userLevel == 6){
            //用户等级为森林之星

            //升级西田森合伙人条件
            int recommendSeedling = 100;
            int recommendForestStart = 1;
            int teamSilver = 90;
            int teamGold = 50;
            int teamFarmer = 50;

            //当前用户条件
            Integer recommendSeedlingNum = recommendUserMapperByUserId.getSeedlingNum();
            Integer recommendForestStartNum = recommendUserMapperByUserId.getForestStartNum();
            Integer teamSilverTreeNum = teamUserInfobyUserId.getSilverTreeNum();
            Integer teamGoldTreeNum = teamUserInfobyUserId.getGoldTreeNum();
            Integer teamFarmerNum = teamUserInfobyUserId.getFarmerNum();

            int recommendDifferenceSeedling = recommendSeedling - recommendSeedlingNum;
            if(recommendDifferenceSeedling < 0 ){
                recommendDifferenceSeedling = 0;
            }
            int recommendDifferenceForestStart = recommendForestStart - recommendForestStartNum;
            if (recommendDifferenceForestStart < 0){
                recommendDifferenceForestStart = 0;
            }
            int teamDifferenceSilver = teamSilver - teamSilverTreeNum;
            if (teamDifferenceSilver < 0 ){
                teamDifferenceSilver = 0;
            }
            int teamDifferenceGold = teamGold - teamGoldTreeNum;
            if (teamDifferenceGold < 0 ){
                teamDifferenceGold = 0;
            }
            int teamDifferenceFarmer = teamFarmer - teamFarmerNum;
            if (teamDifferenceFarmer < 0){
                teamDifferenceFarmer = 0;
            }
            //距离升级所差百分比
            float perenctFloat = ((float) (recommendSeedlingNum + recommendForestStartNum + teamSilverTreeNum + teamGoldTreeNum + teamFarmerNum)
                    / (recommendSeedling + recommendForestStart + teamSilver + teamGold + teamFarmer));
            float perenct = (float) Math.round(perenctFloat*100)/100;
            userForestStatusMap.put("perenct",perenct);
            difference.put("recommendDifferenceSeedling",recommendDifferenceSeedling);
            difference.put("recommendDifferenceForestStart",recommendDifferenceForestStart);
            difference.put("teamDifferenceSilver",teamDifferenceSilver);
            difference.put("teamDifferenceGold",teamDifferenceGold);
            difference.put("teamDifferenceFarmer",teamDifferenceFarmer);
            userForestStatusMap.put("differenceMap",difference);
        }else if (userLevel == 7){
            difference.put("null",null);
            userForestStatusMap.put("perenct",1);
            userForestStatusMap.put("differenceMap",difference);
        }

        userForestStatusMap.put("userLevel",userLevel);
        userForestStatusMap.put("recommendUserCount",recommendUserCountByUserId);
        userForestStatusMap.put("teamUserCount",teamUserCount);
        if (teamCountDouble == null ){
            userForestStatusMap.put("teamCountDouble",0);
        }else {
            userForestStatusMap.put("teamCountDouble",teamCountDouble);
        }

        if (teamNowCount == null){
            userForestStatusMap.put("teamNowCount",0);
        }else {
            userForestStatusMap.put("teamNowCount",teamNowCount);
        }
        return userForestStatusMap;
    }
    
}
