package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.vo.*;
import cn.wisenergy.service.app.WalletService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author 86187
 */
@Api(tags = "钱包展示接口管理")
@RestController
@RequestMapping("/wallet")
@Slf4j
public class WalletController {

    @Autowired
    private WalletService walletService;

    @ApiOperation(value = "获取用户钱包", notes = "获取用户钱包", httpMethod = "GET")
    @ApiImplicitParam(name = "userId", value = "用户id", dataType = "String", required = true)
    @GetMapping("/getMoneyPackage")
    public R<MoneyPackageVo> getMoneyPackage(String userId) {
        log.info("shop-mall[]WalletController[]getMoneyPackage[]input.param.userId:" + userId);
        if (StringUtils.isBlank(userId)) {
            return R.error("入参不能为空!");
        }

        return walletService.getMoneyPackage(userId);
    }

    @ApiOperation(value = "获取用户钱包-可提现", notes = "获取用户钱包-可提现", httpMethod = "GET")
    @ApiImplicitParam(name = "userId", value = "用户id", dataType = "String", required = true)
    @GetMapping("/getWithdrawalAmount")
    public R<WithdrawalAmountVo> getWithdrawalAmount(String userId) {
        log.info("shop-mall[]WalletController[]getWithdrawalAmount[]input.param.userId:" + userId);
        if (StringUtils.isBlank(userId)) {
            return R.error("入参不能为空!");
        }

        return walletService.getWithdrawalAmount(userId);
    }

    @ApiOperation(value = "获取用户钱包-累计收益记录", notes = "获取用户钱包-累计收益记录", httpMethod = "GET")
    @ApiImplicitParam(name = "userId", value = "用户id", dataType = "String", required = true)
    @GetMapping("/showIncomeRecord")
    public R<List<AccumulatedIncomeVo>> showIncomeRecord(String userId) {
        log.info("shop-mall[]WalletController[]showIncomeRecord[]input.param.userId:" + userId);
        if (StringUtils.isBlank(userId)) {
            return R.error("入参不能为空!");
        }

        return walletService.showIncomeRecord(userId);
    }

    @ApiOperation(value = "获取用户钱包-累计收益明细", notes = "获取用户钱包-累计收益明细", httpMethod = "GET")
    @ApiImplicitParam(name = "userId", value = "用户id", dataType = "String", required = true)
    @GetMapping("/queryIncomeDetail")
    public R<MoneyPackageDetailVo> queryIncomeDetail(String userId) {
        log.info("shop-mall[]WalletController[]queryIncomeDetail[]input.param.userId:" + userId);
        if (StringUtils.isBlank(userId)) {
            return R.error("入参不能为空!");
        }

        return walletService.queryIncomeDetail(userId);
    }

    @ApiOperation(value = "提现记录", notes = "提现记录", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", dataType = "String"),
            @ApiImplicitParam(name = "yearMonth", value = "时间(yyyy-MM-dd)", dataType = "String", required = true)
    })
    @GetMapping("/getWithdrawalRecord")
    public R<List<WithdrawalRecordVo>> getWithdrawalRecord(String userId, String yearMonth) {
        log.info("shop-mall[]WalletController[]getWithdrawalRecord[]input.param.userId:{},yearMonth:" + userId, yearMonth);
        if (StringUtils.isBlank(yearMonth)) {
            return R.error("入参不能为空!");
        }

        return walletService.getWithdrawalRecord(userId, yearMonth);
    }
}
