package cn.wisenergy.common.expection;

import cn.wisenergy.common.utils.R;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.AuthorizationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

/**
 * 统一异常处理器
 * @author lut
 */
@Slf4j
@RestControllerAdvice
public class BaseExceptionHandler {

	/**
	 * 处理自定义异常
	 */
	@ExceptionHandler(BaseException.class)
	public R<?> handleRRException(BaseException e){
		log.error(e.getMessage(), e);
		return R.error(e.getCode(), e.getMsg());
	}

	@ExceptionHandler(NoHandlerFoundException.class)
	public R<?> handlerNoFoundException(NoHandlerFoundException e) {
		log.error(e.getMessage(), e);
		return R.error(404, "路径不存在，请检查路径是否正确");
	}

	@ExceptionHandler(DuplicateKeyException.class)
	public R<?> handleDuplicateKeyException(DuplicateKeyException e){
		log.error(e.getMessage(), e);
		return R.error("数据库中已存在该记录");
	}

	@ExceptionHandler(AuthorizationException.class)
	public R<?> handleAuthorizationException(AuthorizationException e){
		log.error(e.getMessage(), e);
		return R.error("没有权限，请联系管理员授权");
	}

}
