package cn.wisenergy.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 时间格式转换工具类
 */
public class TimeUtil {
	private static final String timeFormat = "yyyy-MM-dd HH:mm";
	private static final String dateFormat = "yyyy-MM-dd";

	/**
	 * 时间日期格式
	 * 
	 * @param time
	 * @return
	 * @throws ParseException
	 */
	public static Date getTime(String time) throws ParseException {
		SimpleDateFormat ft = new SimpleDateFormat(timeFormat);
		return ft.parse(time);
	}

	/**
	 * 时间日期格式
	 * 
	 * @param time
	 * @return
	 */
	public static String getTime(Date time) {
		SimpleDateFormat ft = new SimpleDateFormat(timeFormat);
		return ft.format(time);
	}

	/**
	 * 日期格式
	 * 
	 * @param date
	 * @return
	 * @throws ParseException
	 */
	public static Date getDate(String date) throws ParseException {
		SimpleDateFormat ft = new SimpleDateFormat(dateFormat);
		return ft.parse(date);
	}

	/**
	 * 日期格式
	 * 
	 * @param date
	 * @return
	 */
	public static String getDate(Date date) {
		SimpleDateFormat ft = new SimpleDateFormat(dateFormat);
		return ft.format(date);
	}

	/**
	 * 将日期转化成毫秒
	 * 
	 * @param date
	 * @return
	 */
	public static Long getTimeMill(Date date) {
		return date.getTime();
	}

	/**
	 * 将毫秒转化为日期
	 * 
	 * @param time
	 * @return
	 */
	public static Date getTimeMill(Long time) {
		Date date = new Date();
		date.setTime(time);
		return date;
	}

	/**
	 * 两个时间相差的分钟数
	 * 
	 * @param time1
	 * @param time2
	 * @return
	 * @Description:
	 */
	public static Integer getDistanceMinutes(Date time1, Date time2) {
		try {
			SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
			String fromDate = simpleFormat.format(time1);
			String toDate = simpleFormat.format(time2);
			long from = simpleFormat.parse(fromDate).getTime();
			long to = simpleFormat.parse(toDate).getTime();
			int minutes = (int) ((to - from) / (1000 * 60));
			return minutes;
		} catch (ParseException e) {
			e.printStackTrace();
			return 0;
		}

	}
}
