package cn.wisenergy.service.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.BankInfo;
import cn.wisenergy.model.dto.WithdrawBankDto;

/**
 * @author 86187
 */
public interface BankService {
    /**
     * 保存银行卡信息
     *
     * @param bankInfo 银行卡信息
     * @return 银行卡信息
     */
    R<BankInfo> add(BankInfo bankInfo);

    /**
     * 编辑银行卡信息
     *
     * @param bankInfo 银行卡信息
     * @return 银行卡信息
     */
    R<BankInfo> edit(BankInfo bankInfo);

    /**
     * 获取银行卡信息
     *
     * @param userId 用户id
     * @return 银行卡信息
     */
    R<BankInfo> getByUserId(String userId);

    /**
     * 银行卡提现发送验证码
     *
     * @param userId 用户主键id
     * @return true 成功 false 失败
     */
    R<Boolean> bankWithdrawSendSms(String userId);

    /**
     * 用户提现到银行卡
     *
     * @param dto 用户标识
     * @return true 成功 false 失败
     */
    R<Boolean> userWithdrawBank(WithdrawBankDto dto);

}
