package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.BankInfo;
import cn.wisenergy.model.dto.WithdrawBankDto;
import cn.wisenergy.service.app.BankService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author 86187
 */
@Api(tags = "提现银行卡管理")
@RestController
@RequestMapping("/bank")
@Slf4j
public class BankController {
    @Autowired
    private BankService bankService;

    @ApiOperation(value = "保存用户银行卡信息", notes = "保存用户银行卡信息", httpMethod = "POST")
    @ApiImplicitParam(name = "bankInfo", value = "银行卡信息", dataType = "BankInfo")
    @PostMapping("/add")
    public R<BankInfo> add(@RequestBody BankInfo bankInfo) {
        log.info("shop-mall[]BankController[]add[]input.param.bankInfo:" + bankInfo);
        if (null == bankInfo) {
            return R.error("入参为空!");
        }

        return bankService.add(bankInfo);
    }

    @ApiOperation(value = "编辑用户银行卡信息", notes = "编辑用户银行卡信息", httpMethod = "POST")
    @ApiImplicitParam(name = "bankInfo", value = "银行卡信息", dataType = "BankInfo")
    @PostMapping("/edit")
    public R<BankInfo> edit(@RequestBody BankInfo bankInfo) {
        log.info("shop-mall[]BankController[]edit[]input.param.bankInfo:" + bankInfo);
        if (null == bankInfo) {
            return R.error("入参为空!");
        }

        return bankService.edit(bankInfo);
    }

    @ApiOperation(value = "获取银行卡信息", notes = "获取银行卡信息", httpMethod = "GET")
    @ApiImplicitParam(name = "userId", value = "用户id", dataType = "String")
    @GetMapping("/getByUserId")
    public R<BankInfo> getByUserId(String userId) {
        log.info("shop-mall[]BankController[]getByUserId[]input.param.userId:" + userId);
        if (StringUtils.isBlank(userId)) {
            return R.error("入参为空!");
        }
        return bankService.getByUserId(userId);
    }

    @ApiOperation(value = "提现发送短信验证码", notes = "提现发送短信验证码", httpMethod = "GET")
    @ApiImplicitParam(name = "userId", value = "用户id", dataType = "String")
    @GetMapping("/sendSmsCode")
    public R<Boolean> sendSmsCode(String userId) {
        log.info("shop-mall[]BankController[]sendSmsCode[]input.param.userId:" + userId);
        if (StringUtils.isBlank(userId)) {
            return R.error("入参为空!");
        }
        return bankService.bankWithdrawSendSms(userId);
    }

    @ApiOperation(value = "钱包余额-提现", notes = "编辑用户银行卡信息", httpMethod = "POST")
    @ApiImplicitParam(name = "dto", value = "提现信息", dataType = "WithdrawBankDto")
    @PostMapping("/userWithdrawBank")
    public R<Boolean> userWithdrawBank(@RequestBody WithdrawBankDto dto) {
        log.info("shop-mall[]BankController[]userWithdrawBank[]input.param.dto:" + dto);
        if (null == dto) {
            return R.error("入参为空!");
        }

        return bankService.userWithdrawBank(dto);
    }
}
