package cn.wisenergy.web.admin.controller.app;

import cn.wisenergy.common.utils.R;
import cn.wisenergy.model.app.CustomerService;
import cn.wisenergy.service.app.CustomerServiceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * 专属客服
 */
@Api(tags = "专属客服")
@RestController
@RequestMapping("/customerService")
@Slf4j
public class CustomerServiceController {

    @Autowired
    private CustomerServiceService customerServiceService;

    @ApiOperation(value = "获取专属客服", notes = "获取专属客服")
    @GetMapping("/service")
    public R getServiceByRand(){
        try {
            CustomerService serviceByRand = customerServiceService.getServiceByRand();
            String wechatImgUrl = serviceByRand.getWechatImgUrl();
            return R.ok(wechatImgUrl);
        }catch (Exception e){
            return R.error("获取失败，请重试");
        }
    }

    /**
     * String wechatId ,@RequestParam("file") MultipartFile file,
     * 上传专属客服微信二维码图片
     */
    @ResponseBody
    @PostMapping("/uploadWeChatImg")
    public R uploadWeChatQRImg(@RequestParam("file")MultipartFile file,HttpServletRequest request,String wechatId){

        try {
            customerServiceService.uploadImage(file,request,wechatId);
        } catch (IOException e) {
            e.printStackTrace();
            R.error("上传失败");
        }
        return R.ok("上传成功");
    }

}
