package cn.wisenergy.mapper;

import cn.wisenergy.model.app.User;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @ Description:
 * @ Author     : 86187
 * @ Date       : 2021/1/6 15:32
 * @author 86187
 */
@Mapper
public interface UsersMapper extends BaseMapper<User> {
    /**
     * 添加
     *
     * @param user 用户信息
     * @return 用户信息
     */
    int add(User user);

    /**
     * 编辑
     *
     * @param user 用户信息
     * @return 修改是否成功
     */
    int edit(User user);

    /**
     * 删除
     *
     * @param id 用户id
     * @return 删除是否成功
     */
    int delById(@Param("id") Integer id);

    int countByPhoneAnsUserId(@Param("phone") String phone, @Param("userId") Integer userId);

    List<User> getList(Map<String, Object> map);

    Integer getUserNumbers();

    User getByPhone(@Param("phone") String phone);
}
