package cn.wisenergy.model.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ Description: 用户登录操作记录实体类
 * @ Author     : 86187
 * @ Date       : 2021/1/7 15:09
 */
@Data
@ApiModel(value = "LoginRecord")
public class LoginRecord implements Serializable {
    private static final long serialVersionUID = 3450614328514828031L;

    /**
     * 用户操作记录id
     */
    @ApiModelProperty(value = "用户操作记录id", name = "id")
    private Integer id;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", name = "userId")
    private Integer userId;

    /**
     * 类型 1：用户祖册 2：用户登录 3：用户退出
     */
    @ApiModelProperty(value = "类型 1：用户祖册 2：用户登录 3：用户退出", name = "type")
    private Integer type;

    /**
     * 操作名称
     */
    @ApiModelProperty(value = "操作名称", name = "operationName")
    private String operationName;

    /**
     * ip
     */
    @ApiModelProperty(value = "ip", name = "ip")
    private String ip;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", name = "createTime")
    private Date createTime;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间", name = "updateTime")
    private Date updateTime;
}
