package cn.wisenergy.model.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
*@ Description: 充值记录实体类
*@ Author     : 86187
*@ Date       : 2021/1/8 14:48
*/
@Data
@ApiModel(value = "PayRecord")
public class PayRecord implements Serializable {
    private static final long serialVersionUID = -7865361068703566832L;

    /**
     * 充值记录
     */
    @ApiModelProperty(value = "",name = "")
    private Integer id;

    /**
     * 充值类型 1：支付宝 2：微信 3：充值卡
     */
    @ApiModelProperty(value = "",name = "")
    private Integer type;

    /**
     * 充值卡编号
     */
    @ApiModelProperty(value = "充值卡编号",name = "cardId")
    private String cardId;

    /**
     * 充值用户id
     */
    @ApiModelProperty(value = "充值用户id",name = "userId")
    private Integer userId;

    /**
     * 充值所花金额
     */
    @ApiModelProperty(value = "充值所花金额",name = "money")
    private String money;

    /**
     * 充值结果 0：成功 1：失败
     */
    @ApiModelProperty(value = "充值结果 0：成功 1：失败",name = "result")
    private Integer result;
    /**
     * 充值次数
     */
    @ApiModelProperty(value = "充值次数",name = "limit")
    private Integer limit;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间",name = "creteTime")
    private Date createTime;

    /**
     *更改时间
     */
    @ApiModelProperty(value = "更改时间",name = "updateTime")
    private Date updateTime;
}
