package cn.wisenergy.model.app;

import cn.wisenergy.model.common.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @ Description: 方案查询记录
 * @ Author     : 86187
 * @ Date       : 2021/1/8 10:22
 */
@Data
@ApiModel(value = "SchemeQueryRecord")
public class SchemeQueryRecord extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 6600452699328342752L;

    /**
     * 方案查询记录id
     */
    @ApiModelProperty(value = "方案查询记录id", name = "id")
    private Integer id;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", name = "userId")
    private Integer userId;

    /**
     * 专业名称
     */
    @ApiModelProperty(value = "专业名称", name = "majorName")
    private String majorName;

    /**
     * 考生类型 1：本科
     */
    @ApiModelProperty(value = "考生类型 1：本科", name = "studentType")
    private Integer studentType;

    /**
     * 考生分数
     */
    @ApiModelProperty(value = "考生分数", name = "score")
    private String score;
}
